/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.models;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.utils.VlnvReferences;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvRefFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlnvReferencesModel {
    private static final String MISSING_VLNV_MARKER_ID = "org.eclipse.dd.ipxact.editor.ui.vlnvRefMissingFileMarker";
    private static final String WRONG_VLNV_MARKER_ID = "org.eclipse.dd.ipxact.editor.ui.vlnvRefWrongDocumentTypeMarker";
    private static final File MISSING = new File(Messages.VlnvReferencesModel_MissingFile);
    private FileDetails modelFileDetails;
    private final Set<VlnvReferencesModelElement> items = new LinkedHashSet<VlnvReferencesModelElement>();
    private final boolean createMarkers;
    final Set<IMarker> markers = new HashSet<IMarker>();

    public VlnvReferencesModel() {
        this(true);
    }

    public VlnvReferencesModel(boolean createMarkers) {
        this.createMarkers = createMarkers;
    }

    public FileDetails getModelFileDetails() {
        return this.modelFileDetails;
    }

    public void setModelFileDetails(FileDetails fileDetails) {
        this.modelFileDetails = fileDetails;
        this.buildModel();
    }

    private void buildModel() {
        block17: {
            try {
                this.items.clear();
                for (IMarker marker : this.markers) {
                    try {
                        marker.delete();
                    }
                    catch (Exception e) {
                        SpiritUiPlugin.logError(e);
                    }
                }
                this.markers.clear();
                SpiritResourceLibrary library = SpiritResourceLibrary.getDefault();
                if (this.modelFileDetails == null) break block17;
                SpiritDocument spiritDocument = this.modelFileDetails.getSpiritDocument();
                Document xmlDocument = spiritDocument.getDocumentElement().getOwnerDocument();
                List<Element> elements = VlnvRefFilter.getVlnvRefElementList(xmlDocument);
                for (int orderIndex = 0; orderIndex < elements.size(); ++orderIndex) {
                    File fileRef;
                    String documentRefType;
                    Element element = elements.get(orderIndex);
                    if (!VlnvReferences.isReferenceElement((Element)element).booleanValue()) continue;
                    Vlnv vlnvRef = new Vlnv(SpiritNode.createSpiritNode((Element)element));
                    FileDetails fileDetailsRef = library.getFileDetailsForVlnv(vlnvRef);
                    boolean isMissing = false;
                    boolean isWrongType = false;
                    if (fileDetailsRef != null) {
                        SpiritDocument spiritDocumentRef = fileDetailsRef.getSpiritDocument();
                        documentRefType = spiritDocumentRef.getRootTagName();
                        fileRef = fileDetailsRef.getFile();
                        if (!VlnvReferences.checkReferenceValid((Element)element, (SpiritDocument)spiritDocumentRef).booleanValue()) {
                            fileRef = new File(MessageFormat.format(Messages.VlnvReferencesModel_WrongFileType, fileRef));
                            isWrongType = true;
                            if (this.createMarkers) {
                                try {
                                    IFile wsFile = this.modelFileDetails.getWorkspaceFile();
                                    if (wsFile != null) {
                                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                                        attributes.put("message", Messages.VlnvReferencesModel_DocumentType);
                                        attributes.put("severity", new Integer(2));
                                        attributes.put("location", MessageFormat.format(Messages.VlnvReferencesModel_ReferencesWrongType, element.getNodeName(), vlnvRef, documentRefType, VlnvReferences.getExpectedDocumentTypes((Element)element)));
                                        this.createMarker((IResource)wsFile, attributes, WRONG_VLNV_MARKER_ID);
                                    }
                                }
                                catch (Exception e) {
                                    SpiritUiPlugin.logError(e);
                                }
                            }
                        }
                    } else {
                        documentRefType = "";
                        fileRef = MISSING;
                        isMissing = true;
                        if (this.createMarkers) {
                            try {
                                IFile wsFile = this.modelFileDetails.getWorkspaceFile();
                                if (wsFile != null) {
                                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                                    attributes.put("message", Messages.VlnvReferencesModel_MissingVlnv);
                                    attributes.put("severity", new Integer(1));
                                    attributes.put("location", MessageFormat.format(Messages.VlnvReferencesModel_NotFoundInLbrary, element.getNodeName(), vlnvRef));
                                    this.createMarker((IResource)wsFile, attributes, MISSING_VLNV_MARKER_ID);
                                }
                            }
                            catch (Exception e) {
                                SpiritUiPlugin.logError(e);
                            }
                        }
                    }
                    this.items.add(new VlnvReferencesModelElement(this.modelFileDetails.getFile(), element, orderIndex, vlnvRef, fileRef, documentRefType, isMissing, isWrongType));
                }
            }
            catch (Exception e) {
                SpiritUiPlugin.logError(e);
            }
        }
    }

    private void createMarker(final IResource resource, final Map<String, Object> attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
                VlnvReferencesModel.this.markers.add(marker);
            }
        };
        resource.getWorkspace().run(r, null, 1, null);
    }

    public Set<VlnvReferencesModelElement> getItems() {
        return this.items;
    }

    public void dispose() {
        this.items.clear();
    }

    public static class VlnvReferencesModelElement {
        public final File owner;
        public final Element element;
        public final int orderIndex;
        public final Vlnv vlnv;
        public final File file;
        public final String documentType;
        public final boolean isMissing;
        public final boolean isWrongType;

        public VlnvReferencesModelElement(File owner, Element element, int orderIndex, Vlnv vlnv, File file, String documentType, boolean isMissing, boolean isWrongType) {
            this.owner = owner;
            this.element = element;
            this.orderIndex = orderIndex;
            this.vlnv = vlnv;
            this.file = file;
            this.documentType = documentType;
            this.isMissing = isMissing;
            this.isWrongType = isWrongType;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.element.getNodeName());
            stringBuilder.append(" [");
            stringBuilder.append(this.file.toString());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

