/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.UserEditEvent;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class VariableCellModifier
extends WatchExpressionCellModifier {
    private AbstractCachingVMProvider fProvider;
    private SyncVariableDataAccess fDataAccess = null;
    private IFormattedValuePreferenceStore fPrefStore;

    public VariableCellModifier(AbstractCachingVMProvider provider, IFormattedValuePreferenceStore formattedValuePreferenceStore, SyncVariableDataAccess access) {
        this.fProvider = provider;
        this.fDataAccess = access;
        this.fPrefStore = formattedValuePreferenceStore;
    }

    private IExpressions.IExpressionDMContext getVariableDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IExpressions.IExpressionDMContext)((IAdaptable)element).getAdapter(IExpressions.IExpressionDMContext.class);
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.getVariableDMC(element) == null) {
                return false;
            }
            return this.fDataAccess.canWriteExpression(element);
        }
        return super.canModify(element, property);
    }

    public Object getValue(Object element, String property) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            String formatId;
            if (element instanceof IVMContext) {
                IVMContext ctx = (IVMContext)element;
                IPresentationContext presCtx = ctx.getVMNode().getVMProvider().getPresentationContext();
                formatId = this.fPrefStore.getCurrentNumericFormat(presCtx);
            } else {
                formatId = "NATURAL.Format";
            }
            String value = this.fDataAccess.getFormattedValue(element, formatId);
            if (value == null) {
                return "...";
            }
            return value;
        }
        return super.getValue(element, property);
    }

    public void modify(Object element, String property, Object value) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (value instanceof String) {
                String formatId;
                if (element instanceof IVMContext) {
                    IVMContext ctx = (IVMContext)element;
                    IPresentationContext presCtx = ctx.getVMNode().getVMProvider().getPresentationContext();
                    formatId = this.fPrefStore.getCurrentNumericFormat(presCtx);
                } else {
                    formatId = "NATURAL.Format";
                }
                this.fDataAccess.writeVariable(element, (String)value, formatId);
                this.fProvider.handleEvent((Object)new UserEditEvent(element));
            }
        } else {
            super.modify(element, property, value);
        }
    }
}

