/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions;

import java.math.BigInteger;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.IDisassemblyPart;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;

public final class ActionGotoAddress
extends AbstractDisassemblyAction {
    public ActionGotoAddress(IDisassemblyPart disassemblyPart) {
        super(disassemblyPart);
        this.setText(DisassemblyMessages.Disassembly_action_GotoAddress_label);
    }

    public void run() {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String input) {
                if (input == null || input.length() == 0) {
                    return " ";
                }
                try {
                    BigInteger address = DisassemblyPart.decodeAddress(input);
                    if (address.compareTo(BigInteger.ZERO) < 0) {
                        return DisassemblyMessages.Disassembly_GotoAddressDialog_error_invalid_address;
                    }
                }
                catch (NumberFormatException x) {
                    return DisassemblyMessages.Disassembly_GotoAddressDialog_error_not_a_number;
                }
                return null;
            }
        };
        String defaultValue = ((ITextSelection)this.getDisassemblyPart().getSite().getSelectionProvider().getSelection()).getText();
        if (validator.isValid(defaultValue) != null && validator.isValid(defaultValue = DsfDebugUIPlugin.getDefault().getDialogSettings().get("gotoAddress")) != null) {
            defaultValue = "";
        }
        String dlgTitle = DisassemblyMessages.Disassembly_GotoAddressDialog_title;
        String dlgLabel = DisassemblyMessages.Disassembly_GotoAddressDialog_label;
        Shell shell = this.getDisassemblyPart().getSite().getShell();
        InputDialog dlg = new InputDialog(shell, dlgTitle, dlgLabel, defaultValue, validator);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            BigInteger address = DisassemblyPart.decodeAddress(value);
            DsfDebugUIPlugin.getDefault().getDialogSettings().put("gotoAddress", value);
            this.getDisassemblyPart().gotoAddress(address);
        }
    }
}

