/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.views;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvReferencesModel;
import org.eclipse.dd.ipxact.editor.ui.views.FindUsagesSearchQuery;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUsagesSearchResult
implements ISearchResult {
    private final FindUsagesSearchQuery searchQuery;
    private final List<ISearchResultListener> listeners;
    private final Map<File, List<VlnvReferencesModel.VlnvReferencesModelElement>> items;

    public FindUsagesSearchResult(FindUsagesSearchQuery searchQuery) {
        this.searchQuery = searchQuery;
        this.listeners = new ArrayList<ISearchResultListener>();
        this.items = new TreeMap<File, List<VlnvReferencesModel.VlnvReferencesModelElement>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(File file, VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement) {
        Map<File, List<VlnvReferencesModel.VlnvReferencesModelElement>> map = this.items;
        synchronized (map) {
            List<VlnvReferencesModel.VlnvReferencesModelElement> list = this.items.get(file);
            if (list == null) {
                list = new ArrayList<VlnvReferencesModel.VlnvReferencesModelElement>();
                this.items.put(file, list);
            }
            list.add(vlnvReferencesModelElement);
        }
        this.fireSearchResultEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearItems() {
        Map<File, List<VlnvReferencesModel.VlnvReferencesModelElement>> map = this.items;
        synchronized (map) {
            this.items.clear();
        }
        this.fireSearchResultEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private void fireSearchResultEvent() {
        SearchResultEvent searchResultEvent = null;
        for (ISearchResultListener listener : this.listeners) {
            if (searchResultEvent == null) {
                searchResultEvent = new SearchResultEvent(this){};
            }
            listener.searchResultChanged(searchResultEvent);
        }
    }

    public String getLabel() {
        return this.searchQuery.getLabel();
    }

    public String getTooltip() {
        return this.searchQuery.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return SpiritUiPlugin.getImageDescriptor("spirit.gif");
    }

    public ISearchQuery getQuery() {
        return this.searchQuery;
    }

    public Map<File, List<VlnvReferencesModel.VlnvReferencesModelElement>> getItems() {
        return this.items;
    }
}

