/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.traditional;

import java.math.BigInteger;
import org.eclipse.dd.debug.memory.renderings.traditional.AbstractPane;
import org.eclipse.dd.debug.memory.renderings.traditional.Rendering;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalMemoryByte;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class DataPane
extends AbstractPane {
    public DataPane(Rendering parent) {
        super(parent);
    }

    protected String getCellText(MemoryByte[] bytes) {
        return this.fRendering.getRadixText(bytes, this.fRendering.getRadix(), this.fRendering.isTargetLittleEndian());
    }

    protected void editCell(BigInteger address, int subCellPosition, char character) {
        try {
            int i;
            MemoryByte[] bytes = this.fRendering.getBytes(this.fCaretAddress, this.fRendering.getBytesPerColumn());
            String cellText = this.getCellText(bytes);
            if (cellText == null) {
                return;
            }
            StringBuffer cellTextBuffer = new StringBuffer(cellText);
            cellTextBuffer.setCharAt(subCellPosition, character);
            BigInteger value = new BigInteger(cellTextBuffer.toString().trim(), this.fRendering.getNumericRadix(this.fRendering.getRadix()));
            boolean isSignedType = this.fRendering.getRadix() == 2;
            boolean isSigned = isSignedType && value.compareTo(BigInteger.valueOf(0L)) < 0;
            int bitCount = value.bitLength();
            if (isSignedType) {
                ++bitCount;
            }
            if (bitCount > this.fRendering.getBytesPerColumn() * 8) {
                return;
            }
            int byteLen = this.fRendering.getBytesPerColumn();
            byte[] byteData = new byte[byteLen];
            for (int i2 = 0; i2 < byteLen; ++i2) {
                int bits = 255;
                if (isSignedType && i2 == byteLen - 1) {
                    bits = 127;
                }
                byteData[i2] = (byte)(value.and(BigInteger.valueOf(bits)).intValue() & bits);
                value = value.shiftRight(8);
            }
            if (isSigned) {
                int n = byteLen - 1;
                byteData[n] = (byte)(byteData[n] | 0x80);
            }
            if (!this.fRendering.isDisplayLittleEndian()) {
                byte[] byteDataSwapped = new byte[byteData.length];
                for (i = 0; i < byteData.length; ++i) {
                    byteDataSwapped[i] = byteData[byteData.length - 1 - i];
                }
                byteData = byteDataSwapped;
            }
            if (byteData.length != bytes.length) {
                return;
            }
            TraditionalMemoryByte[] bytesToSet = new TraditionalMemoryByte[bytes.length];
            for (i = 0; i < byteData.length; ++i) {
                bytesToSet[i] = new TraditionalMemoryByte(byteData[i]);
                bytesToSet[i].setBigEndian(bytes[i].isBigEndian());
                bytesToSet[i].setEdited(true);
                bytesToSet[i].setChanged(bytes[i].isChanged());
            }
            this.fRendering.getViewportCache().setEditedValue(address, bytesToSet);
            this.advanceCursor();
            this.redraw();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected int getCellWidth() {
        return this.getCellCharacterCount() * this.getCellCharacterWidth() + this.fRendering.getCellPadding() * 2;
    }

    protected int getCellCharacterCount() {
        return this.fRendering.getRadixCharacterCount(this.fRendering.getRadix(), this.fRendering.getBytesPerColumn());
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.fRendering.getColumnCount() * this.getCellWidth() + this.fRendering.getRenderSpacing(), 100);
    }

    private BigInteger getCellAddressAt(int x, int y) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        int col = x / this.getCellWidth();
        int row = y / this.getCellHeight();
        if (col >= this.fRendering.getColumnCount()) {
            return null;
        }
        address = address.add(BigInteger.valueOf(row * this.fRendering.getColumnCount() * this.fRendering.getAddressesPerColumn()));
        address = address.add(BigInteger.valueOf(col * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    protected Point getCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            int row = (cellOffset *= this.fRendering.getAddressableSize()) / (this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn());
            int col = (cellOffset -= row * this.fRendering.getColumnCount() * this.fRendering.getBytesPerColumn()) / this.fRendering.getBytesPerColumn();
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    protected void positionCaret(int x, int y) {
        try {
            BigInteger cellAddress = this.getCellAddressAt(x, y);
            if (cellAddress != null) {
                Point cellPosition = this.getCellLocation(cellAddress);
                int offset = x - cellPosition.x;
                int subCellCharacterPosition = offset / this.getCellCharacterWidth();
                if (subCellCharacterPosition == this.getCellCharacterCount()) {
                    cellAddress = cellAddress.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn()));
                    subCellCharacterPosition = 0;
                    cellPosition = this.getCellLocation(cellAddress);
                }
                this.fCaret.setLocation(cellPosition.x + subCellCharacterPosition * this.getCellCharacterWidth(), cellPosition.y);
                this.fCaretAddress = cellAddress;
                this.fSubCellCaretPosition = subCellCharacterPosition;
                this.setCaretAddress(this.fCaretAddress);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    protected BigInteger getViewportAddress(int col, int row) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        address = address.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + col) * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    protected void paint(PaintEvent pe) {
        super.paint(pe);
        this.doPaintData(pe);
    }

    protected void doPaintData(PaintEvent pe) {
        GC gc = pe.gc;
        gc.setFont(this.fRendering.getFont());
        int cellHeight = this.getCellHeight();
        int cellWidth = this.getCellWidth();
        int columns = this.fRendering.getColumnCount();
        try {
            BigInteger start = this.fRendering.getViewportStartAddress();
            for (int i = 0; i < this.getBounds().height / cellHeight; ++i) {
                for (int col = 0; col < columns; ++col) {
                    if (this.isOdd(col)) {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorText());
                    } else {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorTextAlternate());
                    }
                    BigInteger cellAddress = start.add(BigInteger.valueOf((i * this.fRendering.getColumnCount() + col) * this.fRendering.getAddressesPerColumn()));
                    MemoryByte[] bytes = this.fRendering.getBytes(cellAddress, this.fRendering.getBytesPerColumn());
                    if (this.fRendering.getSelection().isSelected(cellAddress)) {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorSelection());
                        gc.fillRectangle(cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i, cellWidth, cellHeight);
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorBackground());
                    } else {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorBackground());
                        gc.fillRectangle(cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i, cellWidth, cellHeight);
                        this.applyCustomColor(gc, (TraditionalMemoryByte[])bytes, col);
                    }
                    gc.drawText(this.getCellText(bytes), cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i + this.fRendering.getCellPadding());
                    BigInteger cellEndAddress = cellAddress.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn()));
                    cellEndAddress = cellEndAddress.subtract(BigInteger.valueOf(1L));
                    if (this.fCaretEnabled && cellAddress.compareTo(this.fCaretAddress) <= 0 && cellEndAddress.compareTo(this.fCaretAddress) >= 0) {
                        int x = cellWidth * col + this.fRendering.getCellPadding() + this.fSubCellCaretPosition * this.getCellCharacterWidth();
                        int y = cellHeight * i + this.fRendering.getCellPadding();
                        this.fCaret.setLocation(x, y);
                    }
                    if (!this.fRendering.isDebug()) continue;
                    gc.drawRectangle(cellWidth * col + this.fRendering.getCellPadding(), cellHeight * i + this.fRendering.getCellPadding(), cellWidth, cellHeight);
                }
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_PAINT"), e);
        }
    }

    protected void applyCustomColor(GC gc, TraditionalMemoryByte[] bytes, int col) {
        boolean anyByteEditing = false;
        for (int n = 0; n < bytes.length && !anyByteEditing; ++n) {
            if (!(bytes[n] instanceof TraditionalMemoryByte) || !bytes[n].isEdited()) continue;
            anyByteEditing = true;
        }
        if (this.isOdd(col)) {
            gc.setForeground(this.fRendering.getTraditionalRendering().getColorText());
        } else {
            gc.setForeground(this.fRendering.getTraditionalRendering().getColorTextAlternate());
        }
        gc.setBackground(this.fRendering.getTraditionalRendering().getColorBackground());
        if (anyByteEditing) {
            gc.setForeground(this.fRendering.getTraditionalRendering().getColorEdit());
        } else {
            boolean isColored = false;
            block1: for (int i = 0; i < this.fRendering.getHistoryDepth() && !isColored; ++i) {
                for (int n = 0; n < bytes.length; ++n) {
                    if (!bytes[n].isChanged(i)) continue;
                    if (i == 0) {
                        gc.setForeground(this.fRendering.getTraditionalRendering().getColorsChanged()[i]);
                    } else {
                        gc.setBackground(this.fRendering.getTraditionalRendering().getColorsChanged()[i]);
                    }
                    isColored = true;
                    continue block1;
                }
            }
        }
    }
}

