/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourceDocumentProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DsfDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dd.dsf.debug.ui";
    private static DsfDebugUIPlugin plugin;
    private static BundleContext fgBundleContext;
    private SourceDocumentProvider fSourceDocumentProvider;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        fgBundleContext = context;
        this.fSourceDocumentProvider = new SourceDocumentProvider();
    }

    public void stop(BundleContext context) throws Exception {
        this.fSourceDocumentProvider.dispose();
        this.fSourceDocumentProvider = null;
        plugin = null;
        super.stop(context);
    }

    public static DsfDebugUIPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DsfDebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static SourceDocumentProvider getSourceDocumentProvider() {
        return DsfDebugUIPlugin.getDefault().fSourceDocumentProvider;
    }

    public static void log(IStatus status) {
        DsfDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, PLUGIN_ID, 120, "Error within Debug UI: ", t);
            DsfDebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void log(Throwable t) {
        DsfDebugUIPlugin.log(DsfDebugUIPlugin.newErrorStatus("Error logged from Debug UI: ", t));
    }

    public static void logErrorMessage(String message) {
        DsfDebugUIPlugin.log(DsfDebugUIPlugin.newErrorStatus("Internal message logged from Debug UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }
}

