/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckAddressing {
    public static int checkAddressing(DocumentChecker checker) {
        Map<BusInterface, Boolean> busInterfaceIsAddressableMap;
        int nErrors = 0;
        SpiritComponentDocument componentDocumentNode = (SpiritComponentDocument)checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        HashSet<String> hierachicalBusInterfaceNodes = new HashSet<String>();
        NodeList hierarchyRefList = componentDocumentNode.getDescendants("hierarchyRef");
        for (int hrIndex = 0; hrIndex < hierarchyRefList.getLength(); ++hrIndex) {
            Node hierarchyRefNode = hierarchyRefList.item(hrIndex);
            Vlnv designVlnv = new Vlnv(SpiritNode.createSpiritNode((Element)((Element)hierarchyRefNode)));
            SpiritDocument design = library.get(designVlnv);
            if (design == null) continue;
            NodeList hierarchicalBusList = design.getDescendants("hierConnection");
            for (int hbIndex = 0; hbIndex < hierarchicalBusList.getLength(); ++hbIndex) {
                String busInterfaceName = SpiritNode.createSpiritNode((Element)((Element)hierarchicalBusList.item(hbIndex))).getSpiritAttribute("interfaceName");
                BusInterface busInterfaceNode = componentDocumentNode.getBusInterface(busInterfaceName);
                if (busInterfaceNode == null) {
                    reporter.report(CheckList.CHECK_WARNING, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_2, designVlnv, busInterfaceName));
                    ++nErrors;
                    continue;
                }
                hierachicalBusInterfaceNodes.add(busInterfaceNode.getName());
            }
        }
        try {
            busInterfaceIsAddressableMap = CheckAddressing.getBusInterfaceIsAddressableMap(checker);
        }
        catch (Exception e) {
            reporter.report(CheckList.CHECK_WARNING, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_4, e));
            ++nErrors;
            busInterfaceIsAddressableMap = new HashMap<BusInterface, Boolean>(0);
        }
        for (Map.Entry<BusInterface, Boolean> entry : busInterfaceIsAddressableMap.entrySet()) {
            BusInterface busInterface = entry.getKey();
            if (hierachicalBusInterfaceNodes.contains(busInterface.getName())) continue;
            Boolean isAddressable = entry.getValue();
            if (isAddressable == null) {
                isAddressable = Boolean.FALSE;
            }
            if (!isAddressable.booleanValue()) continue;
            if (busInterface.isMaster()) {
                String addressSpaceRef = busInterface.getAddressSpaceRef();
                if (addressSpaceRef.length() == 0) {
                    reporter.report(CheckList.CHECK_57, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_5, busInterface), (SpiritNode)busInterface);
                    ++nErrors;
                    continue;
                }
                if (componentDocumentNode.getAddressSpace(addressSpaceRef) != null) continue;
                reporter.report(CheckList.CHECK_57, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_6, addressSpaceRef), (SpiritNode)busInterface);
                ++nErrors;
                continue;
            }
            if (!busInterface.isSlave()) continue;
            String memoryMapRef = busInterface.getMemoryMapRef();
            if (memoryMapRef.length() != 0) {
                if (componentDocumentNode.getMemoryMap(memoryMapRef) != null) continue;
                reporter.report(CheckList.CHECK_58, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_7, memoryMapRef), (SpiritNode)busInterface);
                ++nErrors;
                continue;
            }
            boolean found = false;
            for (String masterRef : busInterface.getMasterRefs()) {
                Boolean masterIsAddressable = null;
                for (Map.Entry<BusInterface, Boolean> entry2 : busInterfaceIsAddressableMap.entrySet()) {
                    if (!masterRef.equals(entry2.getKey().getName())) continue;
                    masterIsAddressable = entry2.getValue();
                    break;
                }
                if (masterIsAddressable == null) {
                    reporter.report(CheckList.CHECK_58, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_8, masterRef), (SpiritNode)busInterface);
                    ++nErrors;
                    continue;
                }
                if (!masterIsAddressable.booleanValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            reporter.report(CheckList.CHECK_58, (SpiritDocument)componentDocumentNode, MessageFormat.format(Messages.CheckAddressing_9, busInterface), (SpiritNode)busInterface);
            ++nErrors;
        }
        return nErrors;
    }

    private static Map<BusInterface, Boolean> getBusInterfaceIsAddressableMap(DocumentChecker checker) throws Exception {
        HashMap<BusInterface, Boolean> busInterfaceIsAddressableMap = new HashMap<BusInterface, Boolean>();
        HashMap<Vlnv, Boolean> vlnvIsAddressableMap = new HashMap<Vlnv, Boolean>();
        SpiritComponentDocument theDoc = (SpiritComponentDocument)checker.getSpiritDocument();
        SpiritLibrary library = checker.getLibrary();
        List busInterfaces = theDoc.getBusInterfaces();
        for (BusInterface busInterface : busInterfaces) {
            Vlnv vlnv = busInterface.getVlnv();
            SpiritDocument spiritDocument = library.get(vlnv);
            if (!(spiritDocument instanceof SpiritBusDefinitionDocument)) continue;
            Boolean isAddressable = (Boolean)vlnvIsAddressableMap.get(vlnv);
            if (isAddressable == null) {
                isAddressable = Boolean.FALSE;
                List signals = ((SpiritBusDefinitionDocument)spiritDocument).resolveExtends(library);
                for (SpiritSignal signal : signals) {
                    if (!signal.isAddressable()) continue;
                    isAddressable = Boolean.TRUE;
                    break;
                }
                vlnvIsAddressableMap.put(vlnv, isAddressable);
            }
            busInterfaceIsAddressableMap.put(busInterface, isAddressable);
        }
        return busInterfaceIsAddressableMap;
    }
}

