/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.actions;

import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.dd.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IStepOverHandler;

@Immutable
public class DsfStepOverCommand
implements IStepOverHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSteppingModeTarget fSteppingMode;

    public DsfStepOverCommand(DsfSession session, DsfSteppingModeTarget steppingMode) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), session.getId());
        this.fSteppingMode = steppingMode;
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){
            final IRunControl.StepType stepType;
            {
                super(x0, x1, x2);
                this.stepType = DsfStepOverCommand.this.getStepType();
            }

            public void doExecute() {
                this.getStepQueueManager().canEnqueueStep(this.getContext(), this.stepType, (DataRequestMonitor)new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

                    protected void handleCompleted() {
                        request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                        request.done();
                    }
                });
            }
        }));
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        final IRunControl.StepType stepType = this.getStepType();
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                this.getStepQueueManager().enqueueStep(this.getContext(), stepType);
            }
        }));
        return true;
    }

    protected final IRunControl.StepType getStepType() {
        boolean instructionSteppingEnabled = this.fSteppingMode != null && this.fSteppingMode.isInstructionSteppingEnabled();
        return instructionSteppingEnabled ? IRunControl.StepType.INSTRUCTION_STEP_OVER : IRunControl.StepType.STEP_OVER;
    }
}

