/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.views;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dd.ipxact.editor.core.library.ComponentNode;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.IModelChangeListener;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvReferencesModel;
import org.eclipse.dd.ipxact.editor.ui.utils.AutoResizeTableLayout;
import org.eclipse.dd.ipxact.editor.ui.utils.EditorHelper;
import org.eclipse.dd.ipxact.editor.ui.views.PartListenerAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class ReferencesView
extends ViewPart
implements ISetSelectionTarget {
    private static final String VIEW_ID = "org.eclipse.dd.ipxact.editor.ui.views.ReferencesView";
    VlnvReferencesModel vlnvReferencesModel;
    Text fileNameText;
    TableViewer tableViewer;
    private IModelChangeListener modelChangeListener;
    private ISelectionListener selectionListener;
    private IPartListener2 partListener;
    Action gotoItemAction;

    public void createPartControl(Composite parent) {
        IEditorPart editor;
        this.vlnvReferencesModel = new VlnvReferencesModel();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.fileNameText = new Text(parent, 0);
        this.fileNameText.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.fileNameText.setEditable(false);
        this.tableViewer = new TableViewer(parent, 68356);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        table.setLayout((Layout)layout);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.ReferencesView_Element);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("VLNV");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.ReferencesView_File);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this.tableViewer.setComparator((ViewerComparator)new TableViewerComparator(this.tableViewer));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!selection.isEmpty()) {
                    ReferencesView.this.selectReveal(selection);
                }
            }
        };
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        StructuredSelection selection = StructuredSelection.EMPTY;
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null) {
            selection = new StructuredSelection((Object)editor);
        }
        this.selectReveal((ISelection)selection);
        this.partListener = new PartListenerAdapter(){

            public void partActivated(IWorkbenchPartReference partRef) {
                this.partChanged(partRef);
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                this.partChanged(partRef);
            }

            private void partChanged(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof IEditorPart) {
                    ReferencesView.this.selectReveal((ISelection)new StructuredSelection((Object)part));
                }
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
        this.modelChangeListener = new ModelChangeListener();
        SpiritResourceLibrary.getDefault().addListener(this.modelChangeListener);
        this.makeActions();
        this.createContextMenu();
        this.hookDoubleClickAction();
        this.tableViewer.setInput((Object)this.vlnvReferencesModel);
    }

    private void makeActions() {
        this.gotoItemAction = new Action(Messages.ReferencesView_GotoItem, null){

            public void run() {
                ISelection selection = ReferencesView.this.tableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    EditorHelper.openSpecialSelectionInEditor(ReferencesView.this.getSite().getPage(), ((IStructuredSelection)selection).getFirstElement());
                }
            }
        };
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReferencesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(VIEW_ID, menuMgr, (ISelectionProvider)this.tableViewer);
    }

    void fillContextMenu(IMenuManager manager) {
        String GROUP = "content";
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.appendToGroup("content", (IAction)this.gotoItemAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReferencesView.this.gotoItemAction.run();
            }
        });
    }

    public void dispose() {
        SpiritResourceLibrary library;
        if (this.vlnvReferencesModel != null) {
            this.vlnvReferencesModel.dispose();
        }
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        if ((library = SpiritResourceLibrary.getDefault()) != null && this.modelChangeListener != null) {
            library.removeListener(this.modelChangeListener);
        }
        super.dispose();
    }

    public void selectReveal(final ISelection selection) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (ReferencesView.this.tableViewer == null || ReferencesView.this.tableViewer.getControl().isDisposed()) {
                        return;
                    }
                    if (selection instanceof IStructuredSelection) {
                        Object element = ((IStructuredSelection)selection).getFirstElement();
                        IPath location = null;
                        if (element instanceof IResource) {
                            location = ((IResource)element).getLocation();
                        } else if (element instanceof IEditorPart) {
                            IEditorInput editorInput = ((IEditorPart)element).getEditorInput();
                            ILocationProvider locationProvider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
                            if (locationProvider != null) {
                                location = locationProvider.getPath((Object)editorInput);
                                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
                                if (iFile != null) {
                                    location = iFile.getLocation();
                                }
                            }
                        } else if (element instanceof IPath) {
                            location = (IPath)element;
                        } else if (element instanceof ComponentNode) {
                            FileDetails fileDetails = ((ComponentNode)element).getFileDetails();
                            location = new Path(fileDetails.getFile().getAbsolutePath());
                        }
                        if (location != null) {
                            File file = location.toFile();
                            FileDetails fileDetails = SpiritResourceLibrary.getDefault().getFileDetailsForFile(file);
                            if (fileDetails != null) {
                                ReferencesView.this.tableViewer.getTable().setEnabled(true);
                                ReferencesView.this.fileNameText.setText(location.toOSString());
                                ReferencesView.this.vlnvReferencesModel.setModelFileDetails(fileDetails);
                                ReferencesView.this.tableViewer.setInput((Object)ReferencesView.this.vlnvReferencesModel);
                            } else {
                                ReferencesView.this.tableViewer.getTable().setEnabled(false);
                                ReferencesView.this.fileNameText.setText(Messages.ReferencesView_NoFileSelected);
                                ReferencesView.this.tableViewer.setInput((Object)new Object[0]);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    SpiritUiPlugin.logError(e);
                }
            }
        });
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    class ModelChangeListener
    implements IModelChangeListener {
        ModelChangeListener() {
        }

        public void modelChanged() {
            FileDetails fileDetails;
            if (ReferencesView.this.tableViewer == null || ReferencesView.this.tableViewer.getControl().isDisposed()) {
                return;
            }
            Object input = ReferencesView.this.tableViewer.getInput();
            if (input instanceof VlnvReferencesModel && (fileDetails = ((VlnvReferencesModel)input).getModelFileDetails()) != null) {
                ReferencesView.this.selectReveal((ISelection)new StructuredSelection((Object)fileDetails.getLocation()));
            }
        }

        public void duplicateAdded(FileDetails fileDetails, FileDetails primaryEntry) {
        }

        public void duplicateRemoved(FileDetails fileDetails, FileDetails primaryEntry) {
        }
    }

    class TableContentProvider
    extends ArrayContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof VlnvReferencesModel) {
                return ((VlnvReferencesModel)inputElement).getItems().toArray();
            }
            return super.getElements(inputElement);
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            String imageKey = null;
            if (columnIndex == 0) {
                imageKey = "element.gif";
            } else if (columnIndex == 2) {
                VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement = (VlnvReferencesModel.VlnvReferencesModelElement)element;
                String documentType = vlnvReferencesModelElement.documentType;
                imageKey = "component".equals(documentType) ? "spirit_component.gif" : ("busDefinition".equals(documentType) ? "spirit_bus_def.gif" : ("design".equals(documentType) ? "spirit_design.gif" : "spirit.gif"));
                if (vlnvReferencesModelElement.isMissing) {
                    imageKey = "warning.gif";
                }
                if (vlnvReferencesModelElement.isWrongType) {
                    imageKey = "error.gif";
                }
            }
            return SpiritUiPlugin.getImage(imageKey);
        }

        public String getColumnText(Object element, int columnIndex) {
            VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement = (VlnvReferencesModel.VlnvReferencesModelElement)element;
            switch (columnIndex) {
                case 0: {
                    return vlnvReferencesModelElement.element.getNodeName();
                }
                case 1: {
                    return vlnvReferencesModelElement.vlnv.toString();
                }
                case 2: {
                    return vlnvReferencesModelElement.file.toString();
                }
            }
            return Messages.ReferencesView_InvalidData + columnIndex;
        }
    }

    class TableViewerComparator
    extends ViewerComparator {
        int sortByColumn = -1;
        boolean isReversed = false;

        public TableViewerComparator(final TableViewer tableViewer) {
            Table table = tableViewer.getTable();
            int columns = table.getColumnCount();
            for (int index = 0; index < columns; ++index) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ColumnSelectionListener
                extends SelectionAdapter {
                    final int column;

                    public ColumnSelectionListener(int column) {
                        this.column = column;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        TableViewerComparator.this.isReversed = this.column == TableViewerComparator.this.sortByColumn ? !TableViewerComparator.this.isReversed : false;
                        TableViewerComparator.this.sortByColumn = this.column;
                        tableViewer.refresh();
                    }
                }
                table.getColumn(index).addSelectionListener((SelectionListener)new ColumnSelectionListener(index));
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s2;
            String s1;
            VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement1 = (VlnvReferencesModel.VlnvReferencesModelElement)e1;
            VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement2 = (VlnvReferencesModel.VlnvReferencesModelElement)e2;
            switch (this.sortByColumn) {
                default: {
                    return 0;
                }
                case 0: {
                    s1 = vlnvReferencesModelElement1.element.getNodeName();
                    s2 = vlnvReferencesModelElement2.element.getNodeName();
                    break;
                }
                case 1: {
                    s1 = vlnvReferencesModelElement1.vlnv.toString();
                    s2 = vlnvReferencesModelElement2.vlnv.toString();
                    break;
                }
                case 2: {
                    s1 = vlnvReferencesModelElement1.file.toString();
                    s2 = vlnvReferencesModelElement2.file.toString();
                }
            }
            int result = s1.compareToIgnoreCase(s2);
            if (this.isReversed) {
                result = -result;
            }
            return result;
        }
    }
}

