/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression;

import java.util.LinkedList;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionsChangedEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.InvalidExpressionVMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.MessagesForExpressionVM;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.VMExpressionUpdate;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

public class ExpressionManagerVMNode
extends AbstractVMNode
implements IElementLabelProvider,
IElementEditor {
    private IExpressionManager fManager = DebugPlugin.getDefault().getExpressionManager();
    private WatchExpressionCellModifier fWatchExpressionCellModifier = new WatchExpressionCellModifier();

    public ExpressionManagerVMNode(ExpressionVMProvider provider) {
        super((AbstractVMProvider)provider);
    }

    public String toString() {
        return "ExpressionManagerVMNode";
    }

    private ExpressionVMProvider getExpressionVMProvider() {
        return (ExpressionVMProvider)this.getVMProvider();
    }

    public void update(IHasChildrenUpdate[] updates) {
        for (int i = 0; i < updates.length; ++i) {
            updates[i].setHasChilren(this.fManager.getExpressions().length != 0);
            updates[i].done();
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        for (IChildrenCountUpdate update : updates) {
            if (!this.checkUpdate((IViewerUpdate)update)) continue;
            update.setChildCount(this.fManager.getExpressions().length + 1);
            update.done();
        }
    }

    public void update(IChildrenUpdate[] updates) {
        for (IChildrenUpdate update : updates) {
            this.doUpdateChildren(update);
        }
    }

    public void doUpdateChildren(final IChildrenUpdate update) {
        int length;
        IExpression[] expressions = this.fManager.getExpressions();
        ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getVMProvider().getExecutor(), (IViewerUpdate)update);
        int multiRmCount = 0;
        int lowOffset = update.getOffset();
        if (lowOffset < 0) {
            lowOffset = 0;
        }
        if ((length = update.getLength()) <= 0) {
            length = expressions.length;
        }
        int highOffset = lowOffset + length;
        for (int i = lowOffset; i < highOffset && i < expressions.length + 1; ++i) {
            if (i < expressions.length) {
                ++multiRmCount;
                final int childIndex = i;
                IExpression expression = expressions[i];
                ((ExpressionVMProvider)this.getVMProvider()).update(new VMExpressionUpdate((IViewerUpdate)update, expression, new DataRequestMonitor<Object>(this.getVMProvider().getExecutor(), (RequestMonitor)multiRm, (CountingRequestMonitor)multiRm, expression){
                    final /* synthetic */ CountingRequestMonitor val$multiRm;
                    final /* synthetic */ IExpression val$expression;
                    {
                        this.val$multiRm = countingRequestMonitor;
                        this.val$expression = iExpression;
                        super(x0, x1);
                    }

                    protected void handleSuccess() {
                        update.setChild(this.getData(), childIndex);
                        this.val$multiRm.done();
                    }

                    protected void handleError() {
                        update.setChild((Object)new InvalidExpressionVMContext((IVMNode)ExpressionManagerVMNode.this, this.val$expression), childIndex);
                        this.val$multiRm.done();
                    }
                }));
                continue;
            }
            update.setChild((Object)new NewExpressionVMC(), i);
        }
        multiRm.setDoneCount(multiRmCount);
    }

    public void update(ILabelUpdate[] updates) {
        for (ILabelUpdate update : updates) {
            if (update.getElement() instanceof NewExpressionVMC) {
                this.updateNewExpressionVMCLabel(update, (NewExpressionVMC)((Object)update.getElement()));
                continue;
            }
            update.done();
        }
    }

    private void updateNewExpressionVMCLabel(ILabelUpdate update, NewExpressionVMC vmc) {
        String[] stringArray;
        if (update.getColumnIds() != null) {
            stringArray = update.getColumnIds();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME";
        }
        String[] columnIds = stringArray;
        for (int i = 0; i < columnIds.length; ++i) {
            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnIds[i])) {
                update.setLabel(MessagesForExpressionVM.ExpressionManagerLayoutNode__newExpression_label, i);
                update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], i);
                continue;
            }
            update.setLabel("", i);
        }
        update.done();
    }

    public int getDeltaFlags(Object event) {
        int retVal = 0;
        if (event instanceof ExpressionsChangedEvent) {
            retVal |= 0x413;
        }
        for (IExpression expression : this.fManager.getExpressions()) {
            retVal |= this.getExpressionVMProvider().getDeltaFlagsForExpression(expression, event);
        }
        return retVal;
    }

    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof ExpressionsChangedEvent) {
            this.buildDeltaForExpressionsChangedEvent((ExpressionsChangedEvent)event, parentDelta, nodeOffset, requestMonitor);
        } else {
            CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
            int buildDeltaForExpressionCallCount = 0;
            IExpression[] expressions = this.fManager.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                int flags = this.getExpressionVMProvider().getDeltaFlagsForExpression(expressions[i], event);
                if (flags == 0) continue;
                int elementOffset = nodeOffset >= 0 ? nodeOffset + i : -1;
                this.getExpressionVMProvider().buildDeltaForExpression(expressions[i], elementOffset, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
                ++buildDeltaForExpressionCallCount;
            }
            multiRm.setDoneCount(buildDeltaForExpressionCallCount);
        }
    }

    private void buildDeltaForExpressionsChangedEvent(ExpressionsChangedEvent event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
        for (int i = 0; i < event.getExpressions().length; ++i) {
            int expIndex = event.getIndex() != -1 ? nodeOffset + event.getIndex() + i : -1;
            this.getExpressionVMProvider().buildDeltaForExpression(event.getExpressions()[i], expIndex, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
        }
        multiRm.setDoneCount(event.getExpressions().length);
    }

    private TreePath getTreePathFromDelta(IModelDelta delta) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            elementList.add(0, listDelta.getElement());
            listDelta = listDelta.getParentDelta();
        }
        return new TreePath(elementList.toArray());
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fWatchExpressionCellModifier;
    }

    class NewExpressionVMC
    extends AbstractVMContext {
        public NewExpressionVMC() {
            super((IVMNode)ExpressionManagerVMNode.this);
        }

        public Object getAdapter(Class adapter) {
            return super.getAdapter(adapter);
        }

        public boolean equals(Object obj) {
            return obj instanceof NewExpressionVMC;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }
}

