/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourceFileInfo;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

class SourceColorerJob
extends UIJob
implements Runnable {
    private final DisassemblyPart fDisassemblyPart;
    private final ISourceViewer fViewer;
    private final DisassemblyDocument fDocument;
    private final IStorage fStorage;

    public SourceColorerJob(Display jobDisplay, IStorage storage, DisassemblyPart disassemblyPart) {
        super(DisassemblyMessages.SourceColorerJob_name);
        this.fDisassemblyPart = disassemblyPart;
        this.fViewer = disassemblyPart.getTextViewer();
        this.fDocument = (DisassemblyDocument)this.fViewer.getDocument();
        this.fStorage = storage;
        this.setDisplay(this.fDisassemblyPart.getSite().getShell().getDisplay());
        this.setSystem(true);
        this.setPriority(10);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.fViewer != null && !monitor.isCanceled()) {
            monitor.beginTask(DisassemblyMessages.SourceColorerJob_name, -1);
            SourceFileInfo fi = this.fDocument.getSourceInfo(this.fStorage);
            if (fi != null) {
                fi.initPresentationCreator((ITextViewer)this.fViewer);
                if (fi.fError != null) {
                    String message = DisassemblyMessages.Disassembly_log_error_readFile + fi.fFileKey;
                    this.fDisassemblyPart.logWarning(message, fi.fError);
                }
            }
            this.fDisassemblyPart.updateInvalidSource();
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void run() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.fDisassemblyPart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.schedule((Job)this, 0L, true);
        } else {
            this.schedule();
        }
    }
}

