/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.util.LinkedList;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecFinish;
import org.eclipse.dd.mi.service.command.commands.MIExecNext;
import org.eclipse.dd.mi.service.command.commands.MIExecNextInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecReturn;
import org.eclipse.dd.mi.service.command.commands.MIExecStep;
import org.eclipse.dd.mi.service.command.commands.MIExecStepInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecUntil;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIEvent;
import org.eclipse.dd.mi.service.command.events.MIFunctionFinishedEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorSignalExitEvent;
import org.eclipse.dd.mi.service.command.events.MILocationReachedEvent;
import org.eclipse.dd.mi.service.command.events.MIRunningEvent;
import org.eclipse.dd.mi.service.command.events.MISignalEvent;
import org.eclipse.dd.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControlEventProcessor
implements IEventListener,
ICommandListener {
    private static final String STOPPED_REASON = "stopped";
    private final AbstractMIControl fCommandControl;
    private final ICommandControlService.ICommandControlDMContext fControlDmc;
    private final DsfServicesTracker fServicesTracker;

    public MIRunControlEventProcessor(AbstractMIControl connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        this.fCommandControl = connection;
        this.fControlDmc = controlDmc;
        this.fServicesTracker = new DsfServicesTracker(MIPlugin.getBundleContext(), this.fCommandControl.getSession().getId());
        connection.addEventListener(this);
        connection.addCommandListener(this);
    }

    @Deprecated
    public MIRunControlEventProcessor(AbstractMIControl connection, IRunControl.IContainerDMContext containerDmc) {
        this(connection, (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, ICommandControlService.ICommandControlDMContext.class));
    }

    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.fServicesTracker.dispose();
    }

    public void eventReceived(Object output) {
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            MIEvent<?> e;
            MIExecAsyncOutput exec;
            String state;
            LinkedList events = new LinkedList();
            if (!(oobr instanceof MIExecAsyncOutput) || !STOPPED_REASON.equals(state = (exec = (MIExecAsyncOutput)oobr).getAsyncClass())) continue;
            this.fCommandControl.resetCurrentThreadLevel();
            this.fCommandControl.resetCurrentStackLevel();
            MIResult[] results = exec.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String reason;
                MIEvent<?> e2;
                String string = results[i].getVariable();
                MIValue val = results[i].getMIValue();
                if (!string.equals("reason") || !(val instanceof MIConst) || (e2 = this.createEvent(reason = ((MIConst)val).getString(), exec)) == null) continue;
                events.add(e2);
            }
            if (events.isEmpty() && (e = this.createEvent(STOPPED_REASON, exec)) != null) {
                events.add(e);
            }
            for (MIEvent mIEvent : events) {
                this.fCommandControl.getSession().dispatchEvent((Object)mIEvent, this.fCommandControl.getProperties());
            }
        }
    }

    protected MIEvent<?> createEvent(String reason, MIExecAsyncOutput exec) {
        String threadId = null;
        MIResult[] results = exec.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (!var.equals("thread-id") || !(val instanceof MIConst)) continue;
            threadId = ((MIConst)val).getString();
        }
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        if (procService == null) {
            return null;
        }
        String groupId = "";
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(this.fControlDmc, groupId);
        IMIContainerDMContext processContainerDmc = procService.createContainerContext(procDmc, groupId);
        Object execDmc = processContainerDmc;
        if (threadId != null) {
            IProcesses.IThreadDMContext threadDmc = procService.createThreadContext(procDmc, threadId);
            execDmc = procService.createExecutionContext(processContainerDmc, threadDmc, threadId);
        }
        MIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = MIBreakpointHitEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = MIWatchpointTriggerEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-scope".equals(reason)) {
            event = MIWatchpointScopeEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("end-stepping-range".equals(reason)) {
            event = MISteppingRangeEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("signal-received".equals(reason)) {
            event = MISignalEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("location-reached".equals(reason)) {
            event = MILocationReachedEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("function-finished".equals(reason)) {
            event = MIFunctionFinishedEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = MIInferiorExitEvent.parse(this.fCommandControl.getContext(), exec.getToken(), exec.getMIResults());
        } else if ("exited-signalled".equals(reason)) {
            event = MIInferiorSignalExitEvent.parse(this.fCommandControl.getContext(), exec.getToken(), exec.getMIResults());
        } else if (STOPPED_REASON.equals(reason)) {
            event = MIStoppedEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        }
        return event;
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        ICommand cmd = token.getCommand();
        MIInfo cmdResult = (MIInfo)result;
        MIOutput output = cmdResult.getMIOutput();
        MIResultRecord rr = output.getMIResultRecord();
        if (rr != null) {
            int id = rr.getToken();
            String state = rr.getResultClass();
            if ("running".equals(state)) {
                int type = 0;
                type = cmd instanceof MIExecNext ? 1 : (cmd instanceof MIExecNextInstruction ? 2 : (cmd instanceof MIExecStep ? 3 : (cmd instanceof MIExecStepInstruction ? 4 : (cmd instanceof MIExecUntil ? 6 : (cmd instanceof MIExecFinish ? 5 : (cmd instanceof MIExecReturn ? 7 : (cmd instanceof MIExecContinue ? 0 : 0)))))));
                IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
                if (procService != null) {
                    String groupId = "";
                    IProcesses.IProcessDMContext procDmc = procService.createProcessContext(this.fControlDmc, groupId);
                    IMIContainerDMContext processContainerDmc = procService.createContainerContext(procDmc, groupId);
                    this.fCommandControl.getSession().dispatchEvent((Object)new MIRunningEvent((IRunControl.IExecutionDMContext)processContainerDmc, id, type), this.fCommandControl.getProperties());
                }
            } else if ("exit".equals(state) || "connected".equals(state) || "error".equals(state)) {
                // empty if block
            }
        }
    }
}

