/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IDisassembly;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.mi.service.IMIBackend;
import org.eclipse.dd.mi.service.MIBreakpointsManager;

public class ShutdownSequence
extends Sequence {
    String fSessionId;
    String fApplicationName;
    String fDebugModelId;
    DsfServicesTracker fTracker;
    private final Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            assert (GdbPlugin.getBundleContext() != null);
            ShutdownSequence.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), ShutdownSequence.this.fSessionId);
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IDisassembly.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IRegisters.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIBreakpointsManager.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IBreakpoints.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ISourceLookup.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IExpressions.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IStack.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IModules.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IMemory.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IRunControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IProcesses.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ICommandControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IMIBackend.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};

    public ShutdownSequence(DsfExecutor executor, String sessionId, RequestMonitor requestMonitor) {
        super(executor, requestMonitor);
        this.fSessionId = sessionId;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private void shutdownService(Class clazz, final RequestMonitor requestMonitor) {
        IDsfService service = (IDsfService)this.fTracker.getService(clazz);
        if (service != null) {
            service.shutdown(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        GdbPlugin.getDefault().getLog().log(this.getStatus());
                    }
                    requestMonitor.done();
                }
            });
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Service '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

