/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb.framework;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.MIStack;
import org.eclipse.dd.mi.service.command.commands.MIBreakDelete;
import org.eclipse.dd.mi.service.command.commands.MIBreakInsert;
import org.eclipse.dd.mi.service.command.commands.MIBreakList;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecFinish;
import org.eclipse.dd.mi.service.command.commands.MIExecNext;
import org.eclipse.dd.mi.service.command.commands.MIExecStep;
import org.eclipse.dd.mi.service.command.commands.MIExecUntil;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.dd.mi.service.command.output.MIBreakListInfo;
import org.eclipse.dd.mi.service.command.output.MIBreakpoint;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.ServiceEventWaitor;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.Assert;

public class SyncUtil {
    private static ICommandControlService fCommandControl;
    private static MIRunControl fRunControl;
    private static MIStack fStack;
    private static IExpressions fExpressions;
    private static DsfSession fSession;
    private static IRunControl.IContainerDMContext fGdbContainerDmc;
    private static IBreakpoints.IBreakpointsTargetDMContext fBreakpointsDmc;

    public static void initialize(DsfSession session) {
        fSession = session;
        DsfServicesTracker tracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), fSession.getId());
        fCommandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
        IMIProcesses procService = (IMIProcesses)tracker.getService(IMIProcesses.class);
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(fCommandControl.getContext(), "");
        fGdbContainerDmc = procService.createContainerContext(procDmc, "");
        fBreakpointsDmc = (IBreakpoints.IBreakpointsTargetDMContext)fCommandControl.getContext();
        fRunControl = (MIRunControl)tracker.getService(MIRunControl.class);
        fStack = (MIStack)tracker.getService(MIStack.class);
        fExpressions = (IExpressions)tracker.getService(IExpressions.class);
        tracker.dispose();
    }

    public static MIStoppedEvent SyncStep(IRunControl.StepType stepType, int numSteps) throws Throwable {
        MIStoppedEvent retVal = null;
        for (int i = 0; i < numSteps; ++i) {
            retVal = SyncUtil.SyncStep(stepType);
        }
        return retVal;
    }

    public static MIStoppedEvent SyncStep(IRunControl.StepType stepType) throws Throwable {
        return SyncUtil.SyncStep((IRunControl.IExecutionDMContext)fGdbContainerDmc, stepType);
    }

    public static MIStoppedEvent SyncStep(final IRunControl.IExecutionDMContext dmc, final IRunControl.StepType stepType) throws Throwable {
        ServiceEventWaitor<MIStoppedEvent> eventWaitor = new ServiceEventWaitor<MIStoppedEvent>(fSession, MIStoppedEvent.class);
        fRunControl.getExecutor().submit(new Runnable(){

            public void run() {
                switch (stepType) {
                    case STEP_INTO: {
                        fCommandControl.queueCommand((ICommand)new MIExecStep(dmc), null);
                        break;
                    }
                    case STEP_OVER: {
                        fCommandControl.queueCommand((ICommand)new MIExecNext(dmc), null);
                        break;
                    }
                    case STEP_RETURN: {
                        fCommandControl.queueCommand((ICommand)new MIExecFinish(fStack.createFrameDMContext(dmc, 0)), null);
                        break;
                    }
                    default: {
                        junit.framework.Assert.assertTrue((String)("Unsupported step type; " + stepType.toString()), (boolean)false);
                    }
                }
            }
        });
        return eventWaitor.waitForEvent(0);
    }

    public static MIStoppedEvent SyncRunToLine(final IRunControl.IExecutionDMContext dmc, final String fileName, final String lineNo, boolean skipBreakpoints) throws Throwable {
        ServiceEventWaitor<MIStoppedEvent> eventWaitor = new ServiceEventWaitor<MIStoppedEvent>(fSession, MIStoppedEvent.class);
        fRunControl.getExecutor().submit(new Runnable(){

            public void run() {
                fCommandControl.queueCommand((ICommand)new MIExecUntil(dmc, fileName + ":" + lineNo), null);
            }
        });
        return eventWaitor.waitForEvent(0);
    }

    public static MIStoppedEvent SyncRunToLine(String fileName, String lineNo, boolean skipBreakpoints) throws Throwable {
        return SyncUtil.SyncRunToLine((IRunControl.IExecutionDMContext)fGdbContainerDmc, fileName, lineNo, skipBreakpoints);
    }

    public static MIStoppedEvent SyncRunToLine(String fileName, String lineNo) throws Throwable {
        return SyncUtil.SyncRunToLine((IRunControl.IExecutionDMContext)fGdbContainerDmc, fileName, lineNo, false);
    }

    public static int SyncAddBreakpoint(String location) throws Throwable {
        return SyncUtil.SyncAddBreakpoint(location, true);
    }

    public static int SyncAddBreakpoint(String location, boolean temporary) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<MIBreakInsertInfo> addBreakDone = new DataRequestMonitor<MIBreakInsertInfo>((Executor)fRunControl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        fCommandControl.queueCommand((ICommand)new MIBreakInsert(fBreakpointsDmc, temporary, false, null, 0, location, 0), (DataRequestMonitor)addBreakDone);
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        MIBreakInsertInfo info = (MIBreakInsertInfo)wait.getReturnInfo();
        return info.getMIBreakpoints()[0].getNumber();
    }

    public static int[] SyncGetBreakpointList() throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<MIBreakListInfo> listDRM = new DataRequestMonitor<MIBreakListInfo>((Executor)fRunControl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        fCommandControl.queueCommand((ICommand)new MIBreakList(fBreakpointsDmc), (DataRequestMonitor)listDRM);
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        MIBreakpoint[] breakpoints = ((MIBreakListInfo)listDRM.getData()).getMIBreakpoints();
        int[] result = new int[breakpoints.length];
        for (int i = 0; i < breakpoints.length; ++i) {
            result[i] = breakpoints[i].getNumber();
        }
        return result;
    }

    public static void SyncDeleteBreakpoint(int breakpointIndex) throws Throwable {
        SyncUtil.SyncDeleteBreakpoint(new int[]{breakpointIndex});
    }

    public static void SyncDeleteBreakpoint(int[] breakpointIndices) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        DataRequestMonitor<MIInfo> deleteBreakDone = new DataRequestMonitor<MIInfo>((Executor)fRunControl.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        fCommandControl.queueCommand((ICommand)new MIBreakDelete(fBreakpointsDmc, breakpointIndices), (DataRequestMonitor)deleteBreakDone);
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
    }

    public static MIStoppedEvent SyncResumeUntilStopped(final IRunControl.IExecutionDMContext dmc) throws Throwable {
        ServiceEventWaitor<MIStoppedEvent> eventWaitor = new ServiceEventWaitor<MIStoppedEvent>(fSession, MIStoppedEvent.class);
        fRunControl.getExecutor().submit(new Runnable(){

            public void run() {
                fCommandControl.queueCommand((ICommand)new MIExecContinue(dmc), null);
            }
        });
        return eventWaitor.waitForEvent(0);
    }

    public static MIStoppedEvent SyncResumeUntilStopped() throws Throwable {
        return SyncUtil.SyncResumeUntilStopped((IRunControl.IExecutionDMContext)fGdbContainerDmc);
    }

    public static MIStoppedEvent SyncRunToLocation(String location) throws Throwable {
        SyncUtil.SyncAddBreakpoint(location, true);
        return SyncUtil.SyncResumeUntilStopped();
    }

    public static IStack.IFrameDMContext SyncGetStackFrame(final IRunControl.IExecutionDMContext execCtx, final int level) throws Throwable {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StackFrameQuery
        extends Query<IStack.IFrameDMContext> {
            StackFrameQuery() {
            }

            protected void execute(final DataRequestMonitor<IStack.IFrameDMContext> rm) {
                fStack.getFrames((IDMContext)execCtx, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext[]>((Executor)fSession.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (((IStack.IFrameDMContext[])this.getData()).length > level) {
                            rm.setData((Object)((IStack.IFrameDMContext[])this.getData())[level]);
                        } else {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.tests.gdb", "Frame not available"));
                        }
                        rm.done();
                    }
                });
            }
        }
        StackFrameQuery sfQuery = new StackFrameQuery();
        fSession.getExecutor().execute((Runnable)((Object)sfQuery));
        return (IStack.IFrameDMContext)sfQuery.get();
    }

    public static IExpressions.IExpressionDMContext SyncCreateExpression(final IDMContext parentCtx, final String expression) throws Throwable {
        Callable<IExpressions.IExpressionDMContext> callable = new Callable<IExpressions.IExpressionDMContext>(){

            @Override
            public IExpressions.IExpressionDMContext call() throws Exception {
                return fExpressions.createExpression(parentCtx, expression);
            }
        };
        return (IExpressions.IExpressionDMContext)fSession.getExecutor().submit((Callable)callable).get();
    }

    public static IFormattedValues.FormattedValueDMContext SyncGetFormattedValue(final IFormattedValues service, final IFormattedValues.IFormattedDataDMContext dmc, final String formatId) throws Throwable {
        Callable<IFormattedValues.FormattedValueDMContext> callable = new Callable<IFormattedValues.FormattedValueDMContext>(){

            @Override
            public IFormattedValues.FormattedValueDMContext call() throws Exception {
                return service.getFormattedValueContext(dmc, formatId);
            }
        };
        return (IFormattedValues.FormattedValueDMContext)fSession.getExecutor().submit((Callable)callable).get();
    }

    public static IMIExecutionDMContext SyncCreateExecutionContext(final IRunControl.IContainerDMContext parentCtx, final int threadId) throws Throwable {
        Callable<IMIExecutionDMContext> callable = new Callable<IMIExecutionDMContext>(){

            @Override
            public IMIExecutionDMContext call() throws Exception {
                return fRunControl.createMIExecutionContext(parentCtx, threadId);
            }
        };
        return (IMIExecutionDMContext)fSession.getExecutor().submit((Callable)callable).get();
    }
}

