/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.traditional;

import java.math.BigInteger;
import org.eclipse.dd.debug.memory.renderings.traditional.CopyAction;
import org.eclipse.dd.debug.memory.renderings.traditional.Rendering;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalRenderingMessages;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalRenderingPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractPane
extends Canvas {
    protected Rendering fRendering;
    protected boolean fSelectionStarted = false;
    protected boolean fSelectionInProgress = false;
    protected BigInteger fSelectionStartAddress = null;
    protected int fSelectionStartAddressSubPosition;
    protected Caret fCaret = null;
    protected int fSubCellCaretPosition = 0;
    protected int fOldSubCellCaretPosition = 0;
    protected boolean fCaretEnabled = false;
    protected BigInteger fCaretAddress = null;
    protected int fRowCount = 0;
    protected boolean fPaneVisible = true;
    private int fCellHeight = -1;
    private int fCharacterWidth = -1;
    private int fTextHeight = -1;

    public AbstractPane(Rendering rendering) {
        super((Composite)rendering, 0x20000000);
        this.fRendering = rendering;
        try {
            this.fCaretAddress = rendering.getBigBaseAddress();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setFont(this.fRendering.getFont());
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        this.fCaret = new Caret((Canvas)this, 0);
        this.fCaret.setSize(1, gc.stringExtent((String)"|").y);
        gc.dispose();
        this.addPaintListener(this.createPaintListener());
        this.addMouseListener(this.createMouseListener());
        this.addMouseMoveListener(this.createMouseMoveListener());
        this.addKeyListener(this.createKeyListener());
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent fe) {
                IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
                if ("saveOnEnterCancelOnFocusLost".equals(store.getString("memoryEditBufferSave"))) {
                    AbstractPane.this.fRendering.getViewportCache().clearEditBuffer();
                } else {
                    AbstractPane.this.fRendering.getViewportCache().writeEditBuffer();
                }
                AbstractPane.this.fSelectionStartAddress = null;
            }

            public void focusGained(FocusEvent fe) {
            }
        });
    }

    protected MouseListener createMouseListener() {
        return new AbstractPaneMouseListener();
    }

    protected MouseMoveListener createMouseMoveListener() {
        return new AbstractPaneMouseMoveListener();
    }

    protected KeyListener createKeyListener() {
        return new AbstractPaneKeyListener();
    }

    protected PaintListener createPaintListener() {
        return new AbstractPanePaintListener();
    }

    protected void handleRightArrowKey() {
        ++this.fSubCellCaretPosition;
        if (this.fSubCellCaretPosition >= this.getCellCharacterCount()) {
            this.fSubCellCaretPosition = 0;
            BigInteger newCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.getNumberOfBytesRepresentedByColumn() / this.fRendering.getAddressableSize()));
            if (newCaretAddress.compareTo(this.fRendering.getMemoryBlockEndAddress()) > 0) {
                this.fSubCellCaretPosition = this.getCellCharacterCount();
            } else {
                this.setCaretAddress(newCaretAddress);
            }
        }
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleLeftArrowKey() {
        --this.fSubCellCaretPosition;
        if (this.fSubCellCaretPosition < 0) {
            this.fSubCellCaretPosition = this.getCellCharacterCount() - 1;
            BigInteger newCaretAddress = this.fCaretAddress.subtract(BigInteger.valueOf(this.getNumberOfBytesRepresentedByColumn() / this.fRendering.getAddressableSize()));
            if (newCaretAddress.compareTo(this.fRendering.getMemoryBlockStartAddress()) < 0) {
                this.fSubCellCaretPosition = 0;
            } else {
                this.setCaretAddress(newCaretAddress);
            }
        }
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleDownArrowKey() {
        BigInteger newCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.fRendering.getAddressableCellsPerRow()));
        this.setCaretAddress(newCaretAddress);
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleUpArrowKey() {
        BigInteger newCaretAddress = this.fCaretAddress.subtract(BigInteger.valueOf(this.fRendering.getAddressableCellsPerRow()));
        this.setCaretAddress(newCaretAddress);
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handlePageDownKey() {
        BigInteger newCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.fRendering.getAddressableCellsPerRow() * (this.fRendering.getRowCount() - 1)));
        this.setCaretAddress(newCaretAddress);
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handlePageUpKey() {
        BigInteger newCaretAddress = this.fCaretAddress.subtract(BigInteger.valueOf(this.fRendering.getAddressableCellsPerRow() * (this.fRendering.getRowCount() - 1)));
        this.setCaretAddress(newCaretAddress);
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void handleMouseDoubleClick(MouseEvent me) {
        try {
            BigInteger address = this.getViewportAddress(me.x / this.getCellWidth(), me.y / this.getCellHeight());
            this.fRendering.getSelection().clear();
            this.fRendering.getSelection().setStart(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn())), address);
            this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn())), address);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    protected boolean isPaneVisible() {
        return this.fPaneVisible;
    }

    protected void setPaneVisible(boolean visible) {
        this.fPaneVisible = visible;
        this.setVisible(visible);
    }

    protected int getNumberOfBytesRepresentedByColumn() {
        return this.fRendering.getBytesPerColumn();
    }

    protected void editCell(BigInteger address, int subCellPosition, char character) {
    }

    protected void setCaretAddress(BigInteger caretAddress) {
        if (caretAddress.compareTo(this.fRendering.getMemoryBlockStartAddress()) >= 0 && caretAddress.compareTo(this.fRendering.getMemoryBlockEndAddress()) <= 0) {
            this.fCaretAddress = caretAddress;
        } else if (caretAddress.compareTo(this.fRendering.getMemoryBlockStartAddress()) < 0) {
            int cellOffset = this.fCaretAddress.subtract(this.fRendering.getViewportStartAddress()).intValue();
            int row = cellOffset / (this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter());
            this.fCaretAddress = this.fRendering.getMemoryBlockStartAddress().add(BigInteger.valueOf((cellOffset -= row * this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getAddressableSize()));
        } else if (caretAddress.compareTo(this.fRendering.getMemoryBlockEndAddress()) > 0) {
            int cellOffset = this.fCaretAddress.subtract(this.fRendering.getViewportEndAddress()).intValue() + 1;
            int row = cellOffset / (this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter());
            this.fCaretAddress = this.fRendering.getMemoryBlockEndAddress().add(BigInteger.valueOf((cellOffset -= row * this.fRendering.getBytesPerRow() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getAddressableSize()));
        }
        this.fRendering.setCaretAddress(this.fCaretAddress);
    }

    protected boolean isOdd(int value) {
        return value / 2 * 2 == value;
    }

    protected void updateCaret() {
        try {
            Point cellPosition;
            if (this.fCaretAddress != null && (cellPosition = this.getCellLocation(this.fCaretAddress)) != null) {
                this.fCaret.setLocation(cellPosition.x + this.fSubCellCaretPosition * this.getCellCharacterWidth(), cellPosition.y);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    protected void ensureCaretWithinViewport() {
        if (this.fCaretAddress.compareTo(this.fRendering.getViewportStartAddress()) < 0) {
            BigInteger difference = this.fRendering.getViewportStartAddress().subtract(this.fCaretAddress);
            BigInteger rows = difference.divide(BigInteger.valueOf(this.fRendering.getBytesPerRow()));
            if (rows.multiply(BigInteger.valueOf(this.fRendering.getBytesPerRow())).compareTo(difference) != 0) {
                rows = rows.add(BigInteger.valueOf(1L));
            }
            this.fRendering.setViewportStartAddress(this.fRendering.getViewportStartAddress().subtract(rows.multiply(BigInteger.valueOf(this.fRendering.getBytesPerRow()))));
            this.fRendering.ensureViewportAddressDisplayable();
            this.fRendering.gotoAddress(this.fRendering.getViewportStartAddress());
        } else if (this.fCaretAddress.compareTo(this.fRendering.getViewportEndAddress()) >= 0) {
            BigInteger difference = this.fCaretAddress.subtract(this.fRendering.getViewportEndAddress().subtract(BigInteger.valueOf(1L)));
            BigInteger rows = difference.divide(BigInteger.valueOf(this.fRendering.getBytesPerRow()));
            if (rows.multiply(BigInteger.valueOf(this.fRendering.getBytesPerRow())).compareTo(difference) != 0) {
                rows = rows.add(BigInteger.valueOf(1L));
            }
            this.fRendering.setViewportStartAddress(this.fRendering.getViewportStartAddress().add(rows.multiply(BigInteger.valueOf(this.fRendering.getBytesPerRow()))));
            this.fRendering.ensureViewportAddressDisplayable();
            this.fRendering.gotoAddress(this.fRendering.getViewportStartAddress());
        }
        this.fRendering.setCaretAddress(this.fCaretAddress);
    }

    protected void advanceCursor() {
        ++this.fSubCellCaretPosition;
        if (this.fSubCellCaretPosition >= this.getCellCharacterCount()) {
            this.fSubCellCaretPosition = 0;
            this.fCaretAddress = this.fCaretAddress.add(BigInteger.valueOf(this.getNumberOfBytesRepresentedByColumn() / this.fRendering.getAddressableSize()));
        }
        this.updateCaret();
        this.ensureCaretWithinViewport();
    }

    protected void positionCaret(int x, int y) {
    }

    protected int getRowCount() {
        return this.fRowCount;
    }

    protected void setRowCount() {
        this.fRowCount = this.getBounds().height / this.getCellHeight();
    }

    protected void settingsChanged() {
        this.fSubCellCaretPosition = 0;
    }

    protected void startSelection(int x, int y) {
        try {
            BigInteger address = this.getViewportAddress(x / this.getCellWidth(), y / this.getCellHeight());
            if (address != null) {
                this.fSelectionStartAddress = address;
                Point cellPosition = this.getCellLocation(address);
                if (cellPosition != null) {
                    int offset = x - cellPosition.x;
                    this.fSelectionStartAddressSubPosition = offset / this.getCellCharacterWidth();
                }
                this.fRendering.getSelection().clear();
                this.fRendering.getSelection().setStart(address.add(BigInteger.valueOf(this.fRendering.getBytesPerColumn() / this.fRendering.getAddressableSize())), address);
                this.fSelectionStarted = true;
                new CopyAction(this.fRendering, 2).run();
            }
        }
        catch (DebugException e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_START_SELECTION"), (Exception)((Object)e));
        }
    }

    protected void endSelection(int x, int y) {
        this.appendSelection(x, y);
        this.fSelectionInProgress = false;
    }

    protected void appendSelection(int x, int y) {
        try {
            if (this.fSelectionStartAddress == null) {
                return;
            }
            BigInteger address = this.getViewportAddress(x / this.getCellWidth(), y / this.getCellHeight());
            if (address.compareTo(this.fSelectionStartAddress) == 0) {
                Point cellPosition = this.getCellLocation(address);
                int offset = x - cellPosition.x;
                int subCellCharacterPosition = offset / this.getCellCharacterWidth();
                if (Math.abs(subCellCharacterPosition - this.fSelectionStartAddressSubPosition) > this.getCellCharacterCount() / 4) {
                    this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn())), address);
                } else {
                    this.fRendering.getSelection().setEnd(null, null);
                }
            } else {
                this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getAddressesPerColumn())), address);
            }
            if (this.fRendering.getSelection().getEnd() != null) {
                this.fCaretAddress = this.fRendering.getSelection().getEnd();
                this.fSubCellCaretPosition = 0;
            }
            this.updateCaret();
            new CopyAction(this.fRendering, 2).run();
        }
        catch (DebugException e) {
            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_APPEND_SELECTION"), (Exception)((Object)e));
        }
    }

    protected void paint(PaintEvent pe) {
        this.fRowCount = this.getBounds().height / this.getCellHeight();
        if (this.fRendering.isDirty()) {
            this.fRendering.setDirty(false);
            this.fRendering.refresh();
        }
    }

    protected abstract BigInteger getViewportAddress(int var1, int var2) throws DebugException;

    protected Point getCellLocation(BigInteger address) {
        return null;
    }

    protected String getCellText(MemoryByte[] bytes) {
        return null;
    }

    protected abstract int getCellWidth();

    protected abstract int getCellCharacterCount();

    public void setFont(Font font) {
        super.setFont(font);
        this.fCharacterWidth = -1;
        this.fCellHeight = -1;
        this.fTextHeight = -1;
    }

    protected int getCellHeight() {
        if (this.fCellHeight == -1) {
            this.fCellHeight = this.getCellTextHeight() + this.fRendering.getCellPadding() * 2;
        }
        return this.fCellHeight;
    }

    protected int getCellCharacterWidth() {
        if (this.fCharacterWidth == -1) {
            GC gc = new GC((Drawable)this);
            gc.setFont(this.fRendering.getFont());
            this.fCharacterWidth = gc.getAdvanceWidth('F');
            gc.dispose();
        }
        return this.fCharacterWidth;
    }

    protected int getCellTextHeight() {
        if (this.fTextHeight == -1) {
            GC gc = new GC((Drawable)this);
            gc.setFont(this.fRendering.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            this.fTextHeight = fontMetrics.getHeight();
            gc.dispose();
        }
        return this.fTextHeight;
    }

    class AbstractPanePaintListener
    implements PaintListener {
        AbstractPanePaintListener() {
        }

        public void paintControl(PaintEvent pe) {
            AbstractPane.this.paint(pe);
        }
    }

    class AbstractPaneKeyListener
    implements KeyListener {
        AbstractPaneKeyListener() {
        }

        public void keyPressed(KeyEvent ke) {
            AbstractPane.this.fOldSubCellCaretPosition = AbstractPane.this.fSubCellCaretPosition;
            if ((ke.stateMask & 0x20000) != 0) {
                switch (ke.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        if (AbstractPane.this.fRendering.getSelection().getStart() != null) break;
                        AbstractPane.this.fRendering.getSelection().setStart(AbstractPane.this.fCaretAddress.add(BigInteger.valueOf(AbstractPane.this.fRendering.getAddressesPerColumn())), AbstractPane.this.fCaretAddress);
                    }
                }
            }
            if (ke.keyCode == 0x1000004) {
                AbstractPane.this.handleRightArrowKey();
            } else if (ke.keyCode == 0x1000003 || ke.keyCode == 8) {
                AbstractPane.this.handleLeftArrowKey();
            } else if (ke.keyCode == 0x1000002) {
                AbstractPane.this.handleDownArrowKey();
            } else if (ke.keyCode == 0x1000001) {
                AbstractPane.this.handleUpArrowKey();
            } else if (ke.keyCode == 0x1000006) {
                AbstractPane.this.handlePageDownKey();
            } else if (ke.keyCode == 0x1000005) {
                AbstractPane.this.handlePageUpKey();
            } else if (ke.keyCode == 27) {
                AbstractPane.this.fRendering.getViewportCache().clearEditBuffer();
            } else if (ke.character == '\r') {
                AbstractPane.this.fRendering.getViewportCache().writeEditBuffer();
            } else if (Rendering.isValidEditCharacter(ke.character)) {
                if (AbstractPane.this.fRendering.getSelection().hasSelection()) {
                    AbstractPane.this.setCaretAddress(AbstractPane.this.fRendering.getSelection().getLow());
                    AbstractPane.this.fSubCellCaretPosition = 0;
                }
                AbstractPane.this.editCell(AbstractPane.this.fCaretAddress, AbstractPane.this.fSubCellCaretPosition, ke.character);
            }
            if ((ke.stateMask & 0x20000) != 0) {
                switch (ke.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        AbstractPane.this.fRendering.getSelection().setEnd(AbstractPane.this.fCaretAddress.add(BigInteger.valueOf(AbstractPane.this.fRendering.getAddressesPerColumn())), AbstractPane.this.fCaretAddress);
                    }
                }
            } else if (ke.keyCode != 131072) {
                AbstractPane.this.fRendering.getSelection().clear();
            }
        }

        public void keyReleased(KeyEvent ke) {
        }
    }

    class AbstractPaneMouseMoveListener
    implements MouseMoveListener {
        AbstractPaneMouseMoveListener() {
        }

        public void mouseMove(MouseEvent me) {
            if (AbstractPane.this.fSelectionStarted) {
                AbstractPane.this.fSelectionInProgress = true;
                AbstractPane.this.appendSelection(me.x, me.y);
            }
        }
    }

    class AbstractPaneMouseListener
    implements MouseListener {
        AbstractPaneMouseListener() {
        }

        public void mouseUp(MouseEvent me) {
            AbstractPane.this.positionCaret(me.x, me.y);
            AbstractPane.this.fCaret.setVisible(true);
            if (AbstractPane.this.fSelectionInProgress && me.button == 1) {
                AbstractPane.this.endSelection(me.x, me.y);
            }
            AbstractPane.this.fSelectionStarted = false;
            AbstractPane.this.fSelectionInProgress = false;
        }

        public void mouseDown(MouseEvent me) {
            AbstractPane.this.forceFocus();
            AbstractPane.this.positionCaret(me.x, me.y);
            AbstractPane.this.fCaret.setVisible(false);
            if (me.button == 1) {
                if ((me.stateMask & 0x20000) != 0 && AbstractPane.this.fRendering.getSelection().getStart() != null) {
                    if (AbstractPane.this.fSelectionStartAddress == null) {
                        AbstractPane.this.fSelectionStartAddress = AbstractPane.this.fRendering.getSelection().getStart();
                    }
                    AbstractPane.this.fSelectionStarted = true;
                    AbstractPane.this.appendSelection(me.x, me.y);
                } else {
                    AbstractPane.this.startSelection(me.x, me.y);
                }
            }
        }

        public void mouseDoubleClick(MouseEvent me) {
            AbstractPane.this.handleMouseDoubleClick(me);
        }
    }
}

