/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.util.LinkedList;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecFinish;
import org.eclipse.dd.mi.service.command.commands.MIExecNext;
import org.eclipse.dd.mi.service.command.commands.MIExecNextInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecReturn;
import org.eclipse.dd.mi.service.command.commands.MIExecStep;
import org.eclipse.dd.mi.service.command.commands.MIExecStepInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecUntil;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIEvent;
import org.eclipse.dd.mi.service.command.events.MIFunctionFinishedEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorSignalExitEvent;
import org.eclipse.dd.mi.service.command.events.MILocationReachedEvent;
import org.eclipse.dd.mi.service.command.events.MIRunningEvent;
import org.eclipse.dd.mi.service.command.events.MISignalEvent;
import org.eclipse.dd.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadGroupCreatedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadGroupExitedEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.dd.mi.service.command.output.MIAsyncRecord;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControlEventProcessor_7_0
implements IEventListener,
ICommandListener {
    private static final String STOPPED_REASON = "stopped";
    private static final String RUNNING_REASON = "running";
    private Integer fLastRunningCmdType = null;
    private final AbstractMIControl fCommandControl;
    private final ICommandControlService.ICommandControlDMContext fControlDmc;
    private final DsfServicesTracker fServicesTracker;

    public MIRunControlEventProcessor_7_0(AbstractMIControl connection, ICommandControlService.ICommandControlDMContext controlDmc) {
        this.fCommandControl = connection;
        this.fControlDmc = controlDmc;
        this.fServicesTracker = new DsfServicesTracker(MIPlugin.getBundleContext(), this.fCommandControl.getSession().getId());
        connection.addEventListener(this);
        connection.addCommandListener(this);
    }

    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.fServicesTracker.dispose();
    }

    /*
     * WARNING - void declaration
     */
    public void eventReceived(Object output) {
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            void var11_18;
            MIAsyncRecord exec;
            LinkedList events = new LinkedList();
            if (oobr instanceof MIExecAsyncOutput) {
                MIEvent<?> event;
                exec = (MIExecAsyncOutput)oobr;
                String state = exec.getAsyncClass();
                if (STOPPED_REASON.equals(state)) {
                    MIEvent<?> e;
                    this.fCommandControl.resetCurrentThreadLevel();
                    this.fCommandControl.resetCurrentStackLevel();
                    MIResult[] results = exec.getMIResults();
                    for (int i = 0; i < results.length; ++i) {
                        String reason;
                        MIEvent<?> e2;
                        String string = results[i].getVariable();
                        MIValue val = results[i].getMIValue();
                        if (!string.equals("reason") || !(val instanceof MIConst) || (e2 = this.createEvent(reason = ((MIConst)val).getString(), (MIExecAsyncOutput)exec)) == null) continue;
                        events.add(e2);
                    }
                    if (events.isEmpty() && (e = this.createEvent(STOPPED_REASON, (MIExecAsyncOutput)exec)) != null) {
                        events.add(e);
                    }
                    for (MIEvent mIEvent : events) {
                        this.fCommandControl.getSession().dispatchEvent((Object)mIEvent, this.fCommandControl.getProperties());
                    }
                    continue;
                }
                if (!RUNNING_REASON.equals(state) || (event = this.createEvent(RUNNING_REASON, (MIExecAsyncOutput)exec)) == null) continue;
                this.fCommandControl.getSession().dispatchEvent(event, this.fCommandControl.getProperties());
                continue;
            }
            if (!(oobr instanceof MINotifyAsyncOutput)) continue;
            exec = (MINotifyAsyncOutput)oobr;
            String miEvent = exec.getAsyncClass();
            if ("thread-created".equals(miEvent) || "thread-exited".equals(miEvent)) {
                IMIProcesses procService;
                String threadId = null;
                String groupId = null;
                MIResult[] mIResultArray = exec.getMIResults();
                for (int i = 0; i < mIResultArray.length; ++i) {
                    String var = mIResultArray[i].getVariable();
                    MIValue val = mIResultArray[i].getMIValue();
                    if (var.equals("group-id")) {
                        if (!(val instanceof MIConst)) continue;
                        groupId = ((MIConst)val).getString();
                        continue;
                    }
                    if (!var.equals("id") || !(val instanceof MIConst)) continue;
                    threadId = ((MIConst)val).getString();
                }
                if (groupId == null) {
                    groupId = "";
                }
                if ((procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class)) == null) continue;
                IProcesses.IProcessDMContext procDmc = procService.createProcessContext(this.fControlDmc, groupId);
                IMIContainerDMContext processContainerDmc = procService.createContainerContext(procDmc, groupId);
                MIEvent event = null;
                if ("thread-created".equals(miEvent)) {
                    event = new MIThreadCreatedEvent((IRunControl.IContainerDMContext)processContainerDmc, exec.getToken(), threadId);
                } else if ("thread-exited".equals(miEvent)) {
                    event = new MIThreadExitEvent((IRunControl.IContainerDMContext)processContainerDmc, exec.getToken(), threadId);
                }
                this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
                continue;
            }
            if (!"thread-group-created".equals(miEvent) && !"thread-group-exited".equals(miEvent)) continue;
            String groupId = null;
            MIResult[] results = exec.getMIResults();
            boolean bl = false;
            while (var11_18 < results.length) {
                String var = results[var11_18].getVariable();
                MIValue val = results[var11_18].getMIValue();
                if (var.equals("id") && val instanceof MIConst) {
                    groupId = ((MIConst)val).getString().trim();
                }
                ++var11_18;
            }
            IMIProcesses iMIProcesses = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
            if (groupId == null || iMIProcesses == null) continue;
            IProcesses.IProcessDMContext procDmc = iMIProcesses.createProcessContext(this.fControlDmc, groupId);
            MIEvent event = null;
            if ("thread-group-created".equals(miEvent)) {
                event = new MIThreadGroupCreatedEvent(procDmc, exec.getToken(), groupId);
            } else if ("thread-group-exited".equals(miEvent)) {
                event = new MIThreadGroupExitedEvent(procDmc, exec.getToken(), groupId);
            }
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        }
    }

    protected MIEvent<?> createEvent(String reason, MIExecAsyncOutput exec) {
        String threadId = null;
        String groupId = null;
        MIResult[] results = exec.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue val = results[i].getMIValue();
            if (var.equals("thread-id")) {
                if (!(val instanceof MIConst)) continue;
                threadId = ((MIConst)val).getString();
                continue;
            }
            if (!var.equals("group-id") || !(val instanceof MIConst)) continue;
            groupId = ((MIConst)val).getString();
        }
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        if (procService == null) {
            return null;
        }
        IProcesses.IProcessDMContext procDmc = null;
        IMIContainerDMContext containerDmc = null;
        if (groupId == null) {
            if (threadId != null) {
                containerDmc = procService.createContainerContextFromThreadId(this.fControlDmc, threadId);
                procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            }
        } else {
            procDmc = procService.createProcessContext(this.fControlDmc, groupId);
            containerDmc = procService.createContainerContext(procDmc, groupId);
        }
        Object execDmc = containerDmc;
        if (threadId != null) {
            IProcesses.IThreadDMContext threadDmc = procService.createThreadContext(procDmc, threadId);
            execDmc = procService.createExecutionContext(containerDmc, threadDmc, threadId);
        }
        if (execDmc == null) {
            return null;
        }
        MIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = MIBreakpointHitEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = MIWatchpointTriggerEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-scope".equals(reason)) {
            event = MIWatchpointScopeEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("end-stepping-range".equals(reason)) {
            event = MISteppingRangeEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("signal-received".equals(reason)) {
            event = MISignalEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("location-reached".equals(reason)) {
            event = MILocationReachedEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("function-finished".equals(reason)) {
            event = MIFunctionFinishedEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = MIInferiorExitEvent.parse(this.fCommandControl.getContext(), exec.getToken(), exec.getMIResults());
        } else if ("exited-signalled".equals(reason)) {
            event = MIInferiorSignalExitEvent.parse(this.fCommandControl.getContext(), exec.getToken(), exec.getMIResults());
        } else if (STOPPED_REASON.equals(reason)) {
            event = MIStoppedEvent.parse((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), exec.getMIResults());
        } else if (RUNNING_REASON.equals(reason)) {
            int type = 0;
            if (this.fLastRunningCmdType != null) {
                type = this.fLastRunningCmdType;
                this.fLastRunningCmdType = null;
            }
            event = new MIRunningEvent((IRunControl.IExecutionDMContext)execDmc, exec.getToken(), type);
        }
        return event;
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        String state;
        ICommand cmd = token.getCommand();
        MIInfo cmdResult = (MIInfo)result;
        MIOutput output = cmdResult.getMIOutput();
        MIResultRecord rr = output.getMIResultRecord();
        if (rr != null && RUNNING_REASON.equals(state = rr.getResultClass())) {
            this.fLastRunningCmdType = cmd instanceof MIExecNext ? Integer.valueOf(1) : (cmd instanceof MIExecNextInstruction ? Integer.valueOf(2) : (cmd instanceof MIExecStep ? Integer.valueOf(3) : (cmd instanceof MIExecStepInstruction ? Integer.valueOf(4) : (cmd instanceof MIExecUntil ? Integer.valueOf(6) : (cmd instanceof MIExecFinish ? Integer.valueOf(5) : (cmd instanceof MIExecReturn ? Integer.valueOf(7) : (cmd instanceof MIExecContinue ? Integer.valueOf(0) : Integer.valueOf(0))))))));
        }
    }
}

