/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckAbstractionDefinition;
import org.eclipse.dd.ipxact.checker.core.CheckAbstractions;
import org.eclipse.dd.ipxact.checker.core.CheckAddressing;
import org.eclipse.dd.ipxact.checker.core.CheckChannels;
import org.eclipse.dd.ipxact.checker.core.CheckConfigurableElements;
import org.eclipse.dd.ipxact.checker.core.CheckConstraints;
import org.eclipse.dd.ipxact.checker.core.CheckDesign;
import org.eclipse.dd.ipxact.checker.core.CheckDesignConfig;
import org.eclipse.dd.ipxact.checker.core.CheckHierarchy;
import org.eclipse.dd.ipxact.checker.core.CheckInterconnections;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.CheckMemoryMaps;
import org.eclipse.dd.ipxact.checker.core.CheckMonitorInterfaces;
import org.eclipse.dd.ipxact.checker.core.CheckRegisters;
import org.eclipse.dd.ipxact.checker.core.CheckSignals;
import org.eclipse.dd.ipxact.checker.core.CheckViews;
import org.eclipse.dd.ipxact.checker.core.CheckVlnv;
import org.eclipse.dd.ipxact.checker.core.CheckXML;
import org.eclipse.dd.ipxact.checker.core.FilePathResolver;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractorDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignConfigurationDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;

public class DocumentChecker {
    private final SpiritLibrary theLibrary;
    private FilePathResolver resolver;
    private final SpiritDocument theDoc;
    private final ICheckerReporter reporter;

    public DocumentChecker(SpiritLibrary theLibrary, SpiritDocument theDoc, ICheckerReporter reporter) throws Exception {
        this(theLibrary, theDoc, reporter, null);
    }

    public DocumentChecker(SpiritLibrary theLibrary, SpiritDocument theDoc, ICheckerReporter reporter, File filesetRoot) throws Exception {
        if (theLibrary == null) {
            throw new IllegalArgumentException("DocumentChecker(): Library is null");
        }
        if (theDoc == null) {
            throw new IllegalArgumentException("DocumentChecker(): theDoc is null");
        }
        if (reporter == null) {
            throw new IllegalArgumentException("DocumentChecker(): reporter is null");
        }
        this.theLibrary = theLibrary;
        this.theDoc = theDoc;
        this.reporter = reporter;
        this.resolver = new FilePathResolver(reporter);
        FileDetails fileDetails = theLibrary.getFileDetailsForVlnv(theDoc.getVlnv());
        if (filesetRoot != null) {
            this.resolver.setContext(filesetRoot);
        } else if (fileDetails != null) {
            this.resolver.setContext(fileDetails.getFile());
        }
        this.resolver.setSpiritDocument(theDoc);
    }

    public int check() throws Exception {
        SchemaInfo.IpxactVersion ipxactVersion = SchemaInfo.getIpxactVersion((String)this.theDoc.getDocumentElement().getNamespaceURI());
        int nErrors = 0;
        try {
            nErrors += CheckXML.checkXMLDocumentElement(this);
            nErrors += CheckVlnv.checkVlnv(this);
            nErrors += CheckVlnv.checkLinkTypes(this);
            nErrors += CheckVlnv.checkFileRefs(this);
            nErrors += CheckConfigurableElements.checkDependencies(this);
            if (this.theDoc instanceof SpiritBusDefinitionDocument) {
                switch (ipxactVersion) {
                    case BEFORE_V14: {
                        nErrors += CheckSignals.checkSignalsDefinedForBusDefinition(this);
                        nErrors += CheckSignals.checkNoDuplicateSignalsInBusDefinition(this);
                        break;
                    }
                }
            } else if (this.theDoc instanceof SpiritComponentDocument) {
                nErrors += CheckSignals.checkBusInterfaceSignals(this);
                nErrors += CheckChannels.checkChannels(this);
                nErrors += CheckChannels.checkChannelConnections(this);
                nErrors += CheckRegisters.checkRanges(this);
                nErrors += CheckMemoryMaps.checkMemoryMaps(this);
                nErrors += CheckSignals.checkSignalsDefinedForComponent(this);
                nErrors += CheckAddressing.checkAddressing(this);
                nErrors += CheckHierarchy.checkHierarchy(this);
                nErrors += CheckViews.checkViews(this);
                nErrors += CheckConstraints.checkWireConstraints(this);
                nErrors += CheckAbstractions.checkBusTypeConsistency_114(this);
            } else if (this.theDoc instanceof SpiritDesignDocument) {
                nErrors += CheckInterconnections.checkInterfaceAttributes(this);
                nErrors += CheckInterconnections.checkInterfaceCompatibility(this);
                nErrors += CheckInterconnections.checkInterfaceUniqueness(this);
                nErrors += CheckInterconnections.checkInterfacePolarity(this);
                nErrors += CheckInterconnections.checkDirectConnections(this);
                nErrors += CheckMonitorInterfaces.checkMonitorConnections(this);
                nErrors += CheckInterconnections.checkForMissingRequiredConnections(this);
                nErrors += CheckDesign.checkComponentConfig(this);
                nErrors += CheckConfigurableElements.checkDesignConfigurableElementReferences(this);
            } else if (this.theDoc instanceof SpiritDesignConfigurationDocument) {
                nErrors += CheckDesignConfig.checkInterconnectionRefs(this);
                nErrors += CheckDesignConfig.checkInterconnectionConfiguration(this);
                nErrors += CheckConfigurableElements.checkDesignConfigConfigurableElementReferences(this);
            } else if (this.theDoc instanceof SpiritAbstractorDocument) {
                nErrors += CheckAbstractions.checkBusTypeConsistency_323(this);
                nErrors += CheckSignals.checkAbstractorInterfaceSignals(this);
            } else if (this.theDoc instanceof SpiritAbstractionDefinitionDocument) {
                nErrors += CheckSignals.checkSignalsDefinedForBusDefinition(this);
                nErrors += CheckSignals.checkNoDuplicateSignalsInBusDefinition(this);
                nErrors += CheckAbstractionDefinition.checkAbstractionExtension(this);
                nErrors += CheckConstraints.checkOnMasterSlaveSystemConstraints(this);
            }
        }
        catch (Exception e) {
            this.reporter.report(CheckList.CHECK_ERROR, this.theDoc, Messages.DocumentChecker_3 + e.toString());
            throw e;
        }
        return nErrors;
    }

    public SpiritLibrary getLibrary() {
        return this.theLibrary;
    }

    public SpiritDocument getSpiritDocument() {
        return this.theDoc;
    }

    public ICheckerReporter getReporter() {
        return this.reporter;
    }

    public FilePathResolver getFilePathResolver() {
        return this.resolver;
    }

    public void setFilePathResolver(FilePathResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolver = resolver;
    }

    public SpiritDocument getLinkedDocument(SpiritNode linkNode) throws Exception {
        Vlnv linkRef = new Vlnv(linkNode);
        SpiritDocument linkedDoc = this.theLibrary.get(linkRef);
        if (linkedDoc == null) {
            throw new Exception(MessageFormat.format(Messages.DocumentChecker_7, linkNode.getNodeName(), linkRef));
        }
        return linkedDoc;
    }
}

