/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;

public abstract class CheckXML {
    public static int checkXMLDocumentElement(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        SchemaInfo.IpxactVersion ipxactVersion = theDoc.schemaVersion();
        ICheckerReporter reporter = checker.getReporter();
        String XMLDocumentElement = theDoc.getDocumentElement().getLocalName();
        switch (ipxactVersion) {
            case BEFORE_V14: {
                if (XMLDocumentElement.equals("busDefinition") || XMLDocumentElement.equals("generatorChangeList") || XMLDocumentElement.equals("component") || XMLDocumentElement.equals("generatorChain") || XMLDocumentElement.equals("design") || XMLDocumentElement.equals("designConfiguration") || XMLDocumentElement.equals("pmd") || XMLDocumentElement.equals("looseGeneratorInvocation")) break;
                reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckXML_1, XMLDocumentElement), theDoc.getBaseDocument());
                ++nErrors;
                break;
            }
            case V14: {
                if (XMLDocumentElement.equals("busDefinition") || XMLDocumentElement.equals("abstractor") || XMLDocumentElement.equals("component") || XMLDocumentElement.equals("generatorChain") || XMLDocumentElement.equals("design") || XMLDocumentElement.equals("designConfiguration") || XMLDocumentElement.equals("abstractionDefinition")) break;
                reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckXML_2, XMLDocumentElement), theDoc.getBaseDocument());
                ++nErrors;
            }
        }
        return nErrors;
    }
}

