/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.util;

import org.eclipse.swt.graphics.RGB;

public class HSL {
    public double hue;
    public double saturation;
    public double luminance;

    public HSL(RGB rgb) {
        double red = (double)rgb.red / 255.0;
        double green = (double)rgb.green / 255.0;
        double blue = (double)rgb.blue / 255.0;
        double cmax = Math.max(Math.max(red, green), blue);
        double cmin = Math.min(Math.min(red, green), blue);
        this.luminance = (cmax + cmin) / 2.0;
        if (cmax == cmin) {
            this.hue = 0.0;
            this.saturation = 0.0;
        } else {
            double delta = cmax - cmin;
            this.saturation = this.luminance < 0.5 ? delta / (cmax + cmin) : delta / (2.0 - cmax - cmin);
            this.hue = red == cmax ? (green - blue) / delta : (green == cmax ? 2.0 + (blue - red) / delta : 4.0 + (red - green) / delta);
            this.hue /= 6.0;
            if (this.hue < 0.0) {
                this.hue += 1.0;
            } else if (this.hue > 1.0) {
                this.hue -= 1.0;
            }
        }
    }

    public RGB toRGB() {
        int blue;
        int green;
        int red;
        if (this.saturation == 0.0) {
            green = red = (int)Math.round(255.0 * this.luminance);
            blue = red;
        } else {
            double m2 = this.luminance <= 0.5 ? this.luminance * (1.0 + this.saturation) : this.luminance + this.saturation - this.luminance * this.saturation;
            double m1 = 2.0 * this.luminance - m2;
            red = HSL.hueToColorValue(this.hue + 0.3333333333333333, m1, m2);
            green = HSL.hueToColorValue(this.hue, m1, m2);
            blue = HSL.hueToColorValue(this.hue - 0.3333333333333333, m1, m2);
        }
        return new RGB(red, green, blue);
    }

    private static int hueToColorValue(double hue, double m1, double m2) {
        if (hue < 0.0) {
            hue += 1.0;
        } else if (hue > 1.0) {
            hue -= 1.0;
        }
        double v = 6.0 * hue < 1.0 ? m1 + (m2 - m1) * hue * 6.0 : (2.0 * hue < 1.0 ? m2 : (3.0 * hue < 2.0 ? m1 + (m2 - m1) * (0.6666666666666666 - hue) * 6.0 : m1));
        return (int)Math.round(255.0 * v);
    }

    public String toString() {
        return "HSL {" + this.hue + ", " + this.saturation + ", " + this.luminance + "}";
    }
}

