/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.events;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.tests.dsf.DsfTestPlugin;
import org.eclipse.dd.tests.dsf.events.Service1;
import org.eclipse.dd.tests.dsf.events.Service2;
import org.eclipse.dd.tests.dsf.events.Service3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShutdownSequence
extends Sequence {
    DsfSession fSession;
    DsfServicesTracker fTracker;
    final Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker = new DsfServicesTracker(DsfTestPlugin.getBundleContext(), ShutdownSequence.this.fSession.getId());
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(Service3.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(Service2.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(Service1.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};

    ShutdownSequence(DsfSession session) {
        super(session.getExecutor());
        this.fSession = session;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private void shutdownService(Class<? extends IDsfService> clazz, RequestMonitor requestMonitor) {
        IDsfService service = (IDsfService)this.fTracker.getService(clazz);
        if (service != null) {
            service.shutdown(requestMonitor);
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.tests.dsf", -1, "Service '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

