/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.utils.OSVariable;
import org.w3c.dom.Node;

public class FilePathResolver {
    private ArrayList<File> pathItems = new ArrayList();
    private File context = null;
    private SpiritDocument spiritDocument;
    private Node node;
    private final ICheckerReporter reporter;
    private OSVariable variableStore = new OSVariable();
    private static Pattern VARIABLE_NAME_DATA_PATTERN = Pattern.compile("\\$\\{(\\w+?)\\}");

    public FilePathResolver(ICheckerReporter reporter) throws Exception {
        this.reporter = reporter;
    }

    public void addPathItem(String pathItem) {
        this.pathItems.add(new File(pathItem));
    }

    public String resolve(String path) {
        Matcher m = VARIABLE_NAME_DATA_PATTERN.matcher(path);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String varName = m.group(1);
            String varValue = this.variableStore.get(varName);
            if (varValue == null) {
                this.reporter.report(CheckList.CHECK_76, this.spiritDocument, Messages.FilePathResolver_2 + varName, this.node);
                this.variableStore.addVariable(varName, "???");
                m.appendReplacement(sb, "");
                continue;
            }
            if (varValue.equals("???")) continue;
            varValue = this.resolve(varValue);
            m.appendReplacement(sb, varValue);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public File resolveFilePath(String path, Node theNode) {
        this.setNode(theNode);
        String resolvedPath = this.resolve(path);
        File f = new File(resolvedPath);
        if (f.isAbsolute()) {
            return f.canRead() && !f.isDirectory() ? f : null;
        }
        if (this.context != null && (f = new File(this.context, resolvedPath)).canRead() && !f.isDirectory()) {
            return f;
        }
        for (File pathItem : this.pathItems) {
            f = new File(pathItem, resolvedPath);
            if (!f.canRead() || f.isDirectory()) continue;
            return f;
        }
        return null;
    }

    public void setContext(File context) {
        this.context = context;
        if (context == null) {
            return;
        }
        if (context.isFile()) {
            this.context = context.getParentFile();
        }
    }

    public void setSpiritDocument(SpiritDocument spiritDocument) {
        this.spiritDocument = spiritDocument;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void addVariable(String name, String value) {
        this.variableStore.addVariable(name, value);
    }
}

