/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.views;

import java.io.File;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvReferencesModel;
import org.eclipse.dd.ipxact.editor.ui.views.FindUsagesSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class FindUsagesSearchQuery
implements ISearchQuery {
    private final FindUsagesSearchResult searchResult;
    private final Vlnv vlnv;
    private final String label;

    public FindUsagesSearchQuery(Vlnv vlnv) {
        this.vlnv = vlnv;
        this.searchResult = new FindUsagesSearchResult(this);
        this.label = MessageFormat.format(Messages.FindUsagesSearchQuery_Usages, vlnv);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.clearItems();
        VlnvReferencesModel vlnvReferencesModel = new VlnvReferencesModel();
        SpiritResourceLibrary library = SpiritResourceLibrary.getDefault();
        for (FileDetails fileDetails : library.getFileDetails()) {
            File file = fileDetails.getFile();
            vlnvReferencesModel.setModelFileDetails(fileDetails);
            Set<VlnvReferencesModel.VlnvReferencesModelElement> items = vlnvReferencesModel.getItems();
            for (VlnvReferencesModel.VlnvReferencesModelElement vlnvReferencesModelElement : items) {
                if (!vlnvReferencesModelElement.vlnv.equals((Object)this.vlnv)) continue;
                this.searchResult.addItem(file, vlnvReferencesModelElement);
            }
        }
        return new Status(0, "org.eclipse.dd.ipxact.editor.ui", 0, Messages.FindUsagesSearchQuery_Complete, null);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }
}

