/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIProcessDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIProcesses;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;
import org.eclipse.dd.mi.service.command.commands.CLIMonitorListProcesses;
import org.eclipse.dd.mi.service.command.output.CLIMonitorListProcessesInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBProcesses
extends MIProcesses {
    private IGDBControl fGdb;
    private Map<Integer, String> fProcessNames = new HashMap<Integer, String>();

    public GDBProcesses(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), MIProcesses.class.getName(), GDBProcesses.class.getName()}, new Hashtable());
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        IProcesses.IProcessDMContext procDmc = this.createProcessContext(commandControl.getContext(), "");
        IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, "");
        this.fGdb.getInferiorProcess().setContainerContext((IRunControl.IContainerDMContext)containerDmc);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            MIInferiorProcess inferiorProcess;
            String pidStr = ((IMIProcessDMContext)dmc).getProcId();
            if ((pidStr == null || pidStr.length() == 0) && (inferiorProcess = this.fGdb.getInferiorProcess()) != null) {
                pidStr = inferiorProcess.getPid();
            }
            int pid = -1;
            try {
                pid = Integer.parseInt(pidStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String name = this.fProcessNames.get(pid);
            if (name == null) {
                IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
                name = backend.getProgramPath().lastSegment();
            }
            rm.setData((Object)new MIProcesses.MIThreadDMData(name, pidStr));
            rm.done();
        } else {
            super.getExecutionData(dmc, rm);
        }
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        MIInferiorProcess inferiorProcess = this.fGdb.getInferiorProcess();
        if (!this.fGdb.isConnected() && inferiorProcess != null && inferiorProcess.getState() != MIInferiorProcess.State.TERMINATED) {
            rm.setData((Object)true);
        } else {
            rm.setData((Object)false);
        }
        rm.done();
    }

    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        super.attachDebuggerToProcess(procCtx, (DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBProcesses.this.fGdb.setConnected(true);
                MIInferiorProcess inferiorProcess = GDBProcesses.this.fGdb.getInferiorProcess();
                if (inferiorProcess != null) {
                    inferiorProcess.setPid(((IMIProcessDMContext)procCtx).getProcId());
                }
                rm.setData(this.getData());
                rm.done();
            }
        });
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void detachDebuggerFromProcess(IDMContext dmc, final RequestMonitor rm) {
        super.detachDebuggerFromProcess(dmc, new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBProcesses.this.fGdb.setConnected(false);
                MIInferiorProcess inferiorProcess = GDBProcesses.this.fGdb.getInferiorProcess();
                if (inferiorProcess != null) {
                    inferiorProcess.setPid(null);
                }
                rm.done();
            }
        });
    }

    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        MIInferiorProcess inferiorProcess = this.fGdb.getInferiorProcess();
        if (this.fGdb.isConnected() && inferiorProcess != null && inferiorProcess.getState() != MIInferiorProcess.State.TERMINATED) {
            IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
            if (containerDmc == null) {
                ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
                String groupId = "";
                IProcesses.IProcessDMContext procDmc = this.createProcessContext(controlDmc, groupId);
                IMIContainerDMContext newContainerDmc = this.createContainerContext(procDmc, groupId);
                rm.setData((Object)new IRunControl.IContainerDMContext[]{newContainerDmc});
                rm.done();
            } else {
                super.getProcessesBeingDebugged(dmc, rm);
            }
        } else {
            rm.setData((Object)new IDMContext[0]);
            rm.done();
        }
    }

    public void getRunningProcesses(IDMContext dmc, final DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IGDBBackend backend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        if (backend.getSessionType() == SessionType.LOCAL) {
            IProcessList list = null;
            try {
                list = CCorePlugin.getDefault().getProcessList();
            }
            catch (CoreException e) {
                // empty catch block
            }
            if (list == null) {
                this.fProcessNames.clear();
                rm.setData(null);
            } else {
                this.fProcessNames.clear();
                for (IProcessInfo procInfo : list.getProcessList()) {
                    this.fProcessNames.put(procInfo.getPid(), procInfo.getName());
                }
                rm.setData((Object)this.makeProcessDMCs(controlDmc, list.getProcessList()));
            }
            rm.done();
        } else {
            this.fGdb.queueCommand((ICommand)new CLIMonitorListProcesses(dmc), (DataRequestMonitor)new DataRequestMonitor<CLIMonitorListProcessesInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        for (IProcessInfo procInfo : ((CLIMonitorListProcessesInfo)this.getData()).getProcessList()) {
                            GDBProcesses.this.fProcessNames.put(procInfo.getPid(), procInfo.getName());
                        }
                        rm.setData((Object)GDBProcesses.this.makeProcessDMCs(controlDmc, ((CLIMonitorListProcessesInfo)this.getData()).getProcessList()));
                    } else {
                        GDBProcesses.this.fProcessNames.clear();
                        rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                    }
                    rm.done();
                }
            });
        }
    }

    private IProcesses.IProcessDMContext[] makeProcessDMCs(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        IMIProcessDMContext[] procDmcs = new IMIProcessDMContext[processes.length];
        for (int i = 0; i < procDmcs.length; ++i) {
            procDmcs[i] = this.createProcessContext(controlDmc, Integer.toString(processes[i].getPid()));
        }
        return procDmcs;
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        if (thread instanceof IMIProcessDMContext) {
            this.fGdb.terminate(rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    private class GDBContainerDMC
    extends MIProcesses.MIContainerDMC
    implements IMemory.IMemoryDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }
}

