/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ActiveOrMonitorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Interconnection
extends SpiritNode {
    private String mode = null;

    public Interconnection(Element element) {
        super(element);
    }

    public String getMode(SpiritLibrary library) {
        if (this.mode != null) {
            return this.mode;
        }
        this.mode = "unknown";
        BusInterface busInterface1 = this.getBusInterface1(library);
        BusInterface busInterface2 = this.getBusInterface2(library);
        if (busInterface1 != null && busInterface2 != null) {
            this.mode = busInterface1.isMaster() ? (busInterface2.isSlave() ? "direct" : "master") : (busInterface1.isMirroredMaster() ? "master" : (busInterface1.isSlave() ? (busInterface2.isMaster() ? "direct" : "slave") : (busInterface1.isMirroredSlave() ? "slave" : "system")));
        }
        return this.mode;
    }

    public BusInterface getBusInterface2(SpiritLibrary library) {
        BusInterface busType2 = null;
        NodeList activeInterfaces = this.getDescendants("activeInterface");
        Element activeInterfaceNode2 = (Element)activeInterfaces.item(1);
        if (activeInterfaceNode2 != null) {
            busType2 = new ActiveOrMonitorInterface(activeInterfaceNode2).getBusInterface(library);
        }
        return busType2;
    }

    public BusInterface getBusInterface1(SpiritLibrary library) {
        BusInterface busType1 = null;
        NodeList activeInterfaces = this.getDescendants("activeInterface");
        Element activeInterfaceNode1 = (Element)activeInterfaces.item(0);
        if (activeInterfaceNode1 != null) {
            busType1 = new ActiveOrMonitorInterface(activeInterfaceNode1).getBusInterface(library);
        }
        return busType1;
    }

    public BusInterface getPrimaryBusInterface(SpiritLibrary library) {
        BusInterface busInterface1 = this.getBusInterface1(library);
        BusInterface busInterface2 = this.getBusInterface2(library);
        if (busInterface1 == null) {
            busInterface1 = busInterface2;
            busInterface2 = null;
        }
        if (busInterface1 != null && (busInterface1.isMaster() || busInterface1.isSystem() || busInterface1.isMirroredSlave())) {
            return busInterface1;
        }
        return busInterface2;
    }

    public BusInterface getSecondaryBusInterface(SpiritLibrary library) {
        BusInterface busInterface1 = this.getBusInterface1(library);
        BusInterface busInterface2 = this.getBusInterface2(library);
        if (busInterface1 == null) {
            busInterface1 = busInterface2;
            busInterface2 = null;
        }
        if (busInterface1 != null && (busInterface1.isSlave() || busInterface1.isMirroredSystem() || busInterface1.isMirroredMaster())) {
            return busInterface1;
        }
        return this.getBusInterface2(library);
    }
}

