/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.mi.service.command.output.MIFrame;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIStackListArgumentsInfo
extends MIInfo {
    MIFrame[] frames = null;

    public MIStackListArgumentsInfo(MIOutput out) {
        super(out);
        MIResultRecord rr;
        ArrayList<MIFrame> aList = new ArrayList<MIFrame>(1);
        if (this.isDone() && (rr = out.getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (!var.equals("stack-args")) continue;
                MIValue val = results[i].getMIValue();
                if (val instanceof MIList) {
                    this.parseStack((MIList)val, aList);
                    continue;
                }
                if (!(val instanceof MITuple)) continue;
                this.parseStack((MITuple)val, aList);
            }
        }
        this.frames = aList.toArray(new MIFrame[aList.size()]);
    }

    public MIFrame[] getMIFrames() {
        return this.frames;
    }

    private void parseStack(MIList miList, List<MIFrame> aList) {
        MIResult[] results = miList.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            MIValue value;
            String var = results[i].getVariable();
            if (!var.equals("frame") || !((value = results[i].getMIValue()) instanceof MITuple)) continue;
            aList.add(new MIFrame((MITuple)value));
        }
    }

    private void parseStack(MITuple miTuple, List<MIFrame> aList) {
        MIResult[] results = miTuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            MIValue value;
            String var = results[i].getVariable();
            if (!var.equals("frame") || !((value = results[i].getMIValue()) instanceof MITuple)) continue;
            aList.add(new MIFrame((MITuple)value));
        }
    }
}

