/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.service.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCache
implements ICommandListener {
    private DsfSession fSession;
    private ICommandControl fCommandControl;
    private Set<IDMContext> fAvailableContexts = new HashSet<IDMContext>();
    private Map<IDMContext, HashMap<CommandInfo, CommandResultInfo>> fCachedContexts = new HashMap<IDMContext, HashMap<CommandInfo, CommandResultInfo>>();
    private ArrayList<CommandInfo> fPendingQCommandsSent = new ArrayList();
    private ArrayList<CommandInfo> fPendingQCommandsNotYetSent = new ArrayList();
    private ArrayList<CommandInfo> fPendingQWaitingForCoalescedCompletion = new ArrayList();

    public CommandCache(DsfSession session, ICommandControl control) {
        this.fSession = session;
        this.fCommandControl = control;
        this.fCommandControl.addCommandListener(this);
    }

    private CommandInfo getCoalescedCommand(CommandInfo cmd) {
        for (CommandInfo currentUnsentEntry : new ArrayList<CommandInfo>(this.fPendingQCommandsNotYetSent)) {
            ICommand<ICommandResult> unsentCommand = currentUnsentEntry.getCommand();
            ICommand<ICommandResult> coalescedCmd = unsentCommand.coalesceWith(cmd.getCommand());
            if (coalescedCmd == null) continue;
            CommandInfo coalescedCmdInfo = new CommandInfo(CommandStyle.COALESCED, coalescedCmd, null);
            if (currentUnsentEntry.getCommandstyle() == CommandStyle.COALESCED) {
                for (CommandInfo waitingEntry : new ArrayList<CommandInfo>(this.fPendingQWaitingForCoalescedCompletion)) {
                    if (waitingEntry.getCoalescedCmd() != currentUnsentEntry) continue;
                    waitingEntry.setCoalescedCmd(coalescedCmdInfo);
                }
            } else {
                this.fPendingQWaitingForCoalescedCompletion.add(currentUnsentEntry);
                currentUnsentEntry.setCoalescedCmd(coalescedCmdInfo);
            }
            this.fPendingQCommandsNotYetSent.remove(currentUnsentEntry);
            this.fCommandControl.removeCommand(currentUnsentEntry.fToken);
            return coalescedCmdInfo;
        }
        return null;
    }

    public <V extends ICommandResult> void execute(ICommand<V> command, DataRequestMonitor<V> rm) {
        assert (this.fSession.getExecutor().isInExecutorThread());
        ICommand<ICommandResult> genericCommand = command;
        DataRequestMonitor<V> genericDone = rm;
        CommandInfo cachedCmd = new CommandInfo(CommandStyle.NONCOALESCED, genericCommand, genericDone);
        final IDMContext context = genericCommand.getContext();
        if (this.fCachedContexts.get(context) != null && this.fCachedContexts.get(context).containsKey(cachedCmd)) {
            CommandResultInfo result = this.fCachedContexts.get(context).get(cachedCmd);
            if (result.getStatus().getSeverity() <= 1) {
                ICommandResult v = result.getData();
                rm.setData((Object)v);
            } else {
                rm.setStatus(result.getStatus());
            }
            rm.done();
            return;
        }
        if (!this.isTargetAvailable(command.getContext())) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10001, "Target not available.", null));
            rm.done();
            return;
        }
        for (CommandInfo sentCommand : this.fPendingQCommandsSent) {
            if (!sentCommand.equals(cachedCmd)) continue;
            sentCommand.getRequestMonitorList().add(genericDone);
            return;
        }
        for (CommandInfo notYetSentCommand : this.fPendingQCommandsNotYetSent) {
            if (!notYetSentCommand.equals(cachedCmd)) continue;
            notYetSentCommand.getRequestMonitorList().add(genericDone);
            return;
        }
        CommandInfo coalescedCmd = this.getCoalescedCommand(cachedCmd);
        if (coalescedCmd != null) {
            this.fPendingQWaitingForCoalescedCompletion.add(cachedCmd);
            cachedCmd.setCoalescedCmd(coalescedCmd);
            cachedCmd = coalescedCmd;
        }
        final CommandInfo finalCachedCmd = cachedCmd;
        this.fPendingQCommandsNotYetSent.add(finalCachedCmd);
        finalCachedCmd.fToken = this.fCommandControl.queueCommand(finalCachedCmd.getCommand(), new DataRequestMonitor<ICommandResult>((Executor)this.fSession.getExecutor(), null){

            public void handleCompleted() {
                if (!CommandCache.this.fPendingQCommandsSent.remove(finalCachedCmd)) {
                    return;
                }
                ICommandResult result = (ICommandResult)this.getData();
                IStatus status = this.getStatus();
                if (finalCachedCmd.getCommandstyle() == CommandStyle.COALESCED) {
                    for (CommandInfo waitingEntry : new ArrayList(CommandCache.this.fPendingQWaitingForCoalescedCompletion)) {
                        if (waitingEntry.getCoalescedCmd() != finalCachedCmd) continue;
                        CommandCache.this.fPendingQWaitingForCoalescedCompletion.remove(waitingEntry);
                        ICommandResult subResult = result.getSubsetResult(waitingEntry.getCommand());
                        CommandResultInfo subResultInfo = new CommandResultInfo(subResult, status);
                        if (CommandCache.this.fCachedContexts.get(context) != null) {
                            ((HashMap)CommandCache.this.fCachedContexts.get(context)).put(waitingEntry, subResultInfo);
                        } else {
                            HashMap<CommandInfo, CommandResultInfo> map = new HashMap<CommandInfo, CommandResultInfo>();
                            map.put(waitingEntry, subResultInfo);
                            CommandCache.this.fCachedContexts.put(context, map);
                        }
                        if (!this.isSuccess()) {
                            for (DataRequestMonitor<ICommandResult> pendingRM : waitingEntry.getRequestMonitorList()) {
                                pendingRM.setStatus(status);
                                pendingRM.done();
                            }
                            continue;
                        }
                        assert (subResult != null);
                        Iterator<DataRequestMonitor<ICommandResult>> i$ = waitingEntry.getRequestMonitorList().iterator();
                        while (i$.hasNext()) {
                            DataRequestMonitor<ICommandResult> pendingRM;
                            DataRequestMonitor<ICommandResult> vPendingRM = pendingRM = i$.next();
                            vPendingRM.setData((Object)subResult);
                            vPendingRM.done();
                        }
                    }
                } else {
                    CommandResultInfo resultInfo = new CommandResultInfo(result, status);
                    if (CommandCache.this.fCachedContexts.get(context) != null) {
                        ((HashMap)CommandCache.this.fCachedContexts.get(context)).put(finalCachedCmd, resultInfo);
                    } else {
                        HashMap<CommandInfo, CommandResultInfo> map = new HashMap<CommandInfo, CommandResultInfo>();
                        map.put(finalCachedCmd, resultInfo);
                        CommandCache.this.fCachedContexts.put(context, map);
                    }
                    if (!this.isSuccess()) {
                        for (DataRequestMonitor<ICommandResult> pendingRM : finalCachedCmd.getRequestMonitorList()) {
                            pendingRM.setStatus(status);
                            pendingRM.done();
                        }
                    } else {
                        ICommandResult vResult = result;
                        Iterator<DataRequestMonitor<ICommandResult>> i$ = finalCachedCmd.getRequestMonitorList().iterator();
                        while (i$.hasNext()) {
                            DataRequestMonitor<ICommandResult> pendingRM;
                            DataRequestMonitor<ICommandResult> vPendingRM = pendingRM = i$.next();
                            vPendingRM.setData((Object)vResult);
                            vPendingRM.done();
                        }
                    }
                }
            }
        });
    }

    public void setContextAvailable(IDMContext context, boolean isAvailable) {
        if (isAvailable) {
            this.fAvailableContexts.add(context);
        } else {
            this.fAvailableContexts.remove(context);
            Iterator<IDMContext> itr = this.fAvailableContexts.iterator();
            while (itr.hasNext()) {
                if (!DMContexts.isAncestorOf((IDMContext)context, (IDMContext)itr.next())) continue;
                itr.remove();
            }
        }
    }

    public boolean isTargetAvailable(IDMContext context) {
        for (IDMContext availableContext : this.fAvailableContexts) {
            if (!context.equals(availableContext) && !DMContexts.isAncestorOf((IDMContext)context, (IDMContext)availableContext)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.fCachedContexts.clear();
    }

    @Override
    public void commandRemoved(ICommandToken token) {
    }

    @Override
    public void commandQueued(ICommandToken token) {
    }

    @Override
    public void commandDone(ICommandToken token, ICommandResult result) {
    }

    @Override
    public void commandSent(ICommandToken token) {
        ICommand<ICommandResult> genericCommand = token.getCommand();
        CommandInfo cachedCmd = new CommandInfo(CommandStyle.NONCOALESCED, genericCommand, null);
        for (CommandInfo unqueuedCommand : new ArrayList<CommandInfo>(this.fPendingQCommandsNotYetSent)) {
            if (!unqueuedCommand.equals(cachedCmd)) continue;
            this.fPendingQCommandsNotYetSent.remove(unqueuedCommand);
            this.fPendingQCommandsSent.add(unqueuedCommand);
            break;
        }
    }

    public void reset(IDMContext dmc) {
        if (dmc == null) {
            this.fCachedContexts.clear();
            return;
        }
        Iterator<IDMContext> itr = this.fCachedContexts.keySet().iterator();
        while (itr.hasNext()) {
            IDMContext keyDmc = itr.next();
            if (keyDmc == null || !dmc.equals(keyDmc) && !DMContexts.isAncestorOf((IDMContext)keyDmc, (IDMContext)dmc)) continue;
            itr.remove();
        }
    }

    class CommandResultInfo {
        private final ICommandResult fData;
        private final IStatus fStatus;

        public CommandResultInfo(ICommandResult data, IStatus status) {
            this.fData = data;
            this.fStatus = status;
        }

        public ICommandResult getData() {
            return this.fData;
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandInfo {
        private final List<DataRequestMonitor<ICommandResult>> fCurrentRequestMonitors;
        private final ICommand<ICommandResult> fCommand;
        private final CommandStyle fCmdStyle;
        private CommandInfo fCoalescedCmd;
        private ICommandToken fToken;

        public CommandInfo(CommandStyle cmdstyle, ICommand<ICommandResult> cmd, DataRequestMonitor<ICommandResult> rm) {
            this.fCmdStyle = cmdstyle;
            this.fCommand = cmd;
            this.fCurrentRequestMonitors = new LinkedList<DataRequestMonitor<ICommandResult>>();
            this.fCurrentRequestMonitors.add(rm);
            this.fCoalescedCmd = null;
        }

        public CommandStyle getCommandstyle() {
            return this.fCmdStyle;
        }

        public List<DataRequestMonitor<ICommandResult>> getRequestMonitorList() {
            return this.fCurrentRequestMonitors;
        }

        public ICommand<ICommandResult> getCommand() {
            return this.fCommand;
        }

        public CommandInfo getCoalescedCmd() {
            return this.fCoalescedCmd;
        }

        public void setCoalescedCmd(CommandInfo cmd) {
            this.fCoalescedCmd = cmd;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CommandInfo)) {
                return false;
            }
            CommandInfo otherCmd = (CommandInfo)other;
            return otherCmd.fCommand.equals(this.fCommand);
        }

        public int hashCode() {
            return this.fCommand.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommandStyle {
        COALESCED,
        NONCOALESCED;

    }
}

