/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.ui.IWorkbenchPart;

public class UpdatePoliciesPropertyTester
extends PropertyTester {
    private static final String SUPPORTED = "areUpdatePoliciesSupported";
    private static final String AVAILABLE = "isUpdatePolicyAvailable";
    private static final String ACTIVE = "isUpdatePolicyActive";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IVMProvider provider;
        if (receiver instanceof IVMContext) {
            IVMProvider provider2 = ((IVMContext)receiver).getVMNode().getVMProvider();
            if (provider2 instanceof ICachingVMProvider) {
                return this.testProvider((ICachingVMProvider)provider2, property, expectedValue);
            }
        } else if (receiver instanceof IDebugView && (provider = VMHandlerUtils.getVMProviderForPart((IWorkbenchPart)((IDebugView)receiver))) instanceof ICachingVMProvider) {
            return this.testProvider((ICachingVMProvider)provider, property, expectedValue);
        }
        return false;
    }

    private boolean testProvider(ICachingVMProvider provider, String property, Object expectedValue) {
        if (SUPPORTED.equals(property)) {
            return true;
        }
        if (AVAILABLE.equals(property)) {
            int i$ = 0;
            IVMUpdatePolicy[] arr$ = provider.getAvailableUpdatePolicies();
            int len$ = arr$.length;
            if (i$ < len$) {
                IVMUpdatePolicy policy = arr$[i$];
                return policy.getID().equals(expectedValue);
            }
        } else if (ACTIVE.equals(property)) {
            return expectedValue != null && expectedValue.equals(provider.getActiveUpdatePolicy().getID());
        }
        return false;
    }
}

