/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.dd.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.launching.FinalLaunchSequence;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchUtils;
import org.eclipse.dd.gdb.internal.provisional.launching.ServicesLaunchSequence;
import org.eclipse.dd.gdb.internal.provisional.service.GdbDebugServicesFactory;
import org.eclipse.dd.gdb.internal.provisional.service.GdbDebugServicesFactoryNS;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class GdbLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.dd.gdb";
    private static final String NON_STOP_FIRST_VERSION = "6.8.50";
    private boolean isNonStopSession = false;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching debugger session", 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SessionType sessionType = LaunchUtils.getSessionType(config);
        boolean attach = LaunchUtils.getIsAttach(config);
        GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == SessionType.REMOTE) {
            monitor.subTask("Debugging remote C/C++ application");
        } else {
            monitor.subTask("Debugging local C/C++ application");
        }
        Path exePath = new Path("");
        if (!attach) {
            ICProject project = LaunchUtils.verifyCProject(config);
            exePath = LaunchUtils.verifyProgramPath(config, project);
            LaunchUtils.verifyBinary(config, (IPath)exePath);
        }
        monitor.worked(1);
        String gdbVersion = LaunchUtils.getGDBVersion(config);
        if (this.isNonStopSession && !this.isNonStopSupported(gdbVersion)) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Non-stop mode is only supported starting with GDB 6.8.50", null));
        }
        launch.setServiceFactory(this.newServiceFactory(gdbVersion));
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(launch.getSession(), launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in services launch sequence", e1.getCause()));
        }
        if (monitor.isCanceled()) {
            return;
        }
        launch.initializeControl();
        launch.addCLIProcess("gdb");
        if (!attach) {
            launch.addInferiorProcess(exePath.lastSegment());
        }
        monitor.worked(1);
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Sequence finalLaunchSequence = this.getFinalLaunchSequence(launch.getSession().getExecutor(), launch, sessionType, attach, (IProgressMonitor)subMon2);
        launch.getSession().getExecutor().execute((Runnable)finalLaunchSequence);
        boolean succeed = false;
        try {
            finalLaunchSequence.get();
            return;
        }
        catch (InterruptedException e1) {
            try {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
                catch (ExecutionException e12) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in final launch sequence", e12.getCause()));
                }
            }
            catch (Throwable throwable) {
                if (succeed) throw throwable;
                Query<Object> launchShutdownQuery = new Query<Object>(launch){
                    final /* synthetic */ GdbLaunch val$launch;
                    {
                        this.val$launch = gdbLaunch;
                    }

                    protected void execute(DataRequestMonitor<Object> rm) {
                        this.val$launch.shutdownSession((RequestMonitor)rm);
                    }
                };
                launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                try {
                    launchShutdownQuery.get();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                }
                catch (ExecutionException e) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                }
            }
        }
    }

    protected Sequence getFinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType type, boolean attach, IProgressMonitor pm) {
        return new FinalLaunchSequence(executor, launch, type, attach, pm);
    }

    private boolean isNonStopSession(ILaunchConfiguration config) {
        try {
            boolean nonStopMode = config.getAttribute("org.eclipse.dd.gdb.NON_STOP", false);
            return nonStopMode;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && LaunchUtils.getSessionType(config) == SessionType.CORE) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.isNonStopSession = this.isNonStopSession(configuration);
        GdbLaunch launch = new GdbLaunch(configuration, mode, null);
        launch.initialize();
        launch.setSourceLocator(this.getSourceLocator(configuration, launch.getSession()));
        return launch;
    }

    private ISourceLocator getSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        DsfSourceLookupDirector locator = new DsfSourceLookupDirector(session);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        return locator;
    }

    private HashSet<IProject> getReferencedProjectSet(IProject proj, HashSet<IProject> referencedProjSet) throws CoreException {
        IProject[] projects;
        referencedProjSet.add(proj);
        for (IProject refProject : projects = proj.getReferencedProjects()) {
            if (!refProject.exists() || referencedProjSet.contains(refProject)) continue;
            this.getReferencedProjectSet(refProject, referencedProjSet);
        }
        return referencedProjSet;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] orderedProjects = null;
        ArrayList<IProject> orderedProjList = null;
        ICProject cProject = LaunchUtils.verifyCProject(configuration);
        if (cProject != null) {
            HashSet<IProject> projectSet = this.getReferencedProjectSet(cProject.getProject(), new HashSet<IProject>());
            String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
            if (orderedNames != null) {
                ArrayList<IProject> unorderedProjects = new ArrayList<IProject>(projectSet.size());
                unorderedProjects.addAll(projectSet);
                orderedProjList = new ArrayList<IProject>(projectSet.size());
                block0: for (String projectName : orderedNames) {
                    for (IProject proj : unorderedProjects) {
                        if (!proj.getName().equals(projectName)) continue;
                        orderedProjList.add(proj);
                        unorderedProjects.remove(proj);
                        continue block0;
                    }
                }
                orderedProjList.addAll(unorderedProjects);
                orderedProjects = orderedProjList.toArray(new IProject[orderedProjList.size()]);
            } else {
                IProject[] projects = projectSet.toArray(new IProject[projectSet.size()]);
                orderedProjects = ResourcesPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
            }
        }
        return orderedProjects;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }

    protected boolean existsProblems(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers.length > 0) {
            for (IMarker marker : markers) {
                Integer severity = (Integer)marker.getAttribute("severity");
                if (severity == null) continue;
                return severity >= 2;
            }
        }
        return false;
    }

    private boolean isNonStopSupported(String version) {
        return NON_STOP_FIRST_VERSION.compareTo(version) <= 0;
    }

    protected IDsfDebugServicesFactory newServiceFactory(String version) {
        if (this.isNonStopSession && this.isNonStopSupported(version)) {
            return new GdbDebugServicesFactoryNS(version);
        }
        if (version.startsWith("6.6") || version.startsWith("6.7") || version.startsWith("6.8")) {
            return new GdbDebugServicesFactory(version);
        }
        return new GdbDebugServicesFactory(version);
    }
}

