/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.object.BusInterface;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckAddressing {
    public static int checkAddressing(DocumentChecker checker) throws XPathExpressionException {
        Map<BusInterface, Boolean> busInterfaceIsAddressableMap;
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        ArrayList<Node> hierachicalBusInterfaceNodes = new ArrayList<Node>();
        NodeList hierarchyRefList = checker.getNodes(theDoc.getDocumentElement(), "//spirit:hierarchyRef");
        for (int hrIndex = 0; hrIndex < hierarchyRefList.getLength(); ++hrIndex) {
            Node hierarchyRefNode = hierarchyRefList.item(hrIndex);
            Vlnv designVlnv = checker.getVlnvRef(hierarchyRefNode);
            SpiritDocument design = library.get(designVlnv);
            if (design == null) continue;
            NodeList hierarchicalBusInterfaceList = checker.getNodes(design.getDocumentElement(), "//spirit:hierConnection/@spirit:interfaceName");
            for (int hbiIndex = 0; hbiIndex < hierarchicalBusInterfaceList.getLength(); ++hbiIndex) {
                Node hierarchicalBusInterfaceNameNode = hierarchicalBusInterfaceList.item(hbiIndex);
                String busInterfaceName = hierarchicalBusInterfaceNameNode.getNodeValue().trim();
                Node busInterfaceNode = Utilities.getBusInterface(checker, theDoc.getBaseDocument(), busInterfaceName);
                if (busInterfaceNode == null) {
                    reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckAddressing_2, designVlnv, busInterfaceName));
                    ++nErrors;
                    continue;
                }
                hierachicalBusInterfaceNodes.add(busInterfaceNode);
            }
        }
        ArrayList<Node> nonHierachicalBusInterfaceNodes = new ArrayList<Node>();
        NodeList busInterfaceNodeList = checker.getNodes(theDoc.getDocumentElement(), "//spirit:busInterface");
        for (int index = 0; index < busInterfaceNodeList.getLength(); ++index) {
            Node busInterfaceNode = busInterfaceNodeList.item(index);
            if (hierachicalBusInterfaceNodes.contains(busInterfaceNode)) continue;
            nonHierachicalBusInterfaceNodes.add(busInterfaceNode);
        }
        try {
            busInterfaceIsAddressableMap = CheckAddressing.getBusInterfaceIsAddressableMap(checker);
        }
        catch (Exception e) {
            reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckAddressing_4, e));
            ++nErrors;
            busInterfaceIsAddressableMap = new HashMap<BusInterface, Boolean>(0);
        }
        for (Map.Entry<BusInterface, Boolean> entry : busInterfaceIsAddressableMap.entrySet()) {
            BusInterface busInterface = entry.getKey();
            Node busInterfaceNode = busInterface.getNode();
            if (hierachicalBusInterfaceNodes.contains(busInterfaceNode)) continue;
            Boolean isAddressable = entry.getValue();
            if (isAddressable == null) {
                isAddressable = Boolean.FALSE;
            }
            if (!isAddressable.booleanValue()) continue;
            if (busInterface.isMaster()) {
                String addressSpaceRef = busInterface.getAddressSpaceRef();
                if (addressSpaceRef.length() == 0) {
                    reporter.report(CheckList.CHECK_57, theDoc, MessageFormat.format(Messages.CheckAddressing_5, busInterface), busInterfaceNode);
                    ++nErrors;
                    continue;
                }
                if (Utilities.getAddressSpace(checker, theDoc.getBaseDocument(), addressSpaceRef) != null) continue;
                reporter.report(CheckList.CHECK_57, theDoc, MessageFormat.format(Messages.CheckAddressing_6, addressSpaceRef), busInterfaceNode);
                ++nErrors;
                continue;
            }
            if (!busInterface.isSlave()) continue;
            String memoryMapRef = busInterface.getMemoryMapRef();
            if (memoryMapRef.length() != 0) {
                if (Utilities.getMemoryMap(checker, theDoc.getBaseDocument(), memoryMapRef) != null) continue;
                reporter.report(CheckList.CHECK_58, theDoc, MessageFormat.format(Messages.CheckAddressing_7, memoryMapRef), busInterfaceNode);
                ++nErrors;
                continue;
            }
            boolean found = false;
            for (String masterRef : busInterface.getMasterRefs()) {
                Boolean masterIsAddressable = null;
                for (Map.Entry<BusInterface, Boolean> entry2 : busInterfaceIsAddressableMap.entrySet()) {
                    if (!masterRef.equals(entry2.getKey().getName())) continue;
                    masterIsAddressable = entry2.getValue();
                    break;
                }
                if (masterIsAddressable == null) {
                    reporter.report(CheckList.CHECK_58, theDoc, MessageFormat.format(Messages.CheckAddressing_8, masterRef), busInterfaceNode);
                    ++nErrors;
                    continue;
                }
                if (!masterIsAddressable.booleanValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            reporter.report(CheckList.CHECK_58, theDoc, MessageFormat.format(Messages.CheckAddressing_9, busInterface), busInterfaceNode);
            ++nErrors;
        }
        return nErrors;
    }

    private static Map<BusInterface, Boolean> getBusInterfaceIsAddressableMap(DocumentChecker checker) throws Exception {
        HashMap<BusInterface, Boolean> busInterfaceIsAddressableMap = new HashMap<BusInterface, Boolean>();
        HashMap<Vlnv, Boolean> vlnvIsAddressableMap = new HashMap<Vlnv, Boolean>();
        SpiritDocument theDoc = checker.getSpiritDocument();
        SpiritLibrary library = checker.getLibrary();
        XPath evaluator = checker.getXpathEvaluator();
        NodeList busInterfaceNodeList = checker.getNodes(theDoc.getDocumentElement(), "//spirit:busInterface");
        for (int index = 0; index < busInterfaceNodeList.getLength(); ++index) {
            Node busInterfaceNode = busInterfaceNodeList.item(index);
            BusInterface busInterface = new BusInterface(evaluator, busInterfaceNode);
            Vlnv vlnv = busInterface.getVlnv();
            SpiritDocument spiritDocument = library.get(vlnv);
            if (!(spiritDocument instanceof SpiritBusDefinitionDocument)) continue;
            Boolean isAddressable = (Boolean)vlnvIsAddressableMap.get(vlnv);
            if (isAddressable == null) {
                isAddressable = Boolean.FALSE;
                List signals = ((SpiritBusDefinitionDocument)spiritDocument).resolveExtends(library);
                for (Node signal : signals) {
                    Node isAddressNode = (Node)evaluator.evaluate("spirit:isAddress", signal, XPathConstants.NODE);
                    if (isAddressNode == null || !"true".equals(checker.getTextContent(isAddressNode))) continue;
                    isAddressable = Boolean.TRUE;
                    break;
                }
                vlnvIsAddressableMap.put(vlnv, isAddressable);
            }
            busInterfaceIsAddressableMap.put(busInterface, isAddressable);
        }
        return busInterfaceIsAddressableMap;
    }
}

