/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.LeftRightEvaluator;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.object.BusInterface;
import org.eclipse.dd.ipxact.checker.core.object.Channel;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckChannels {
    public static int checkBusInterfaceSignals(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        XPath xpath = checker.getXpathEvaluator();
        NodeList busIfNodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:busInterface");
        for (int busNodeIndex = 0; busNodeIndex < busIfNodes.getLength(); ++busNodeIndex) {
            ArrayList signalList;
            Node busIfNode = busIfNodes.item(busNodeIndex);
            BusInterface busInterface = new BusInterface(xpath, busIfNode);
            SpiritDocument doc = library.get(busInterface.getVlnv());
            if (doc == null) {
                reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckChannels_1, busInterface.getVlnv(), busIfNode));
                ++nErrors;
                continue;
            }
            if (!(doc instanceof SpiritBusDefinitionDocument)) {
                reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_2, busInterface.getVlnv()), busIfNode);
                ++nErrors;
                continue;
            }
            SpiritBusDefinitionDocument busDefDoc = (SpiritBusDefinitionDocument)doc;
            Vlnv busDefVlnv = busDefDoc.getVlnv();
            String busIfName = busInterface.getName();
            NodeList signalMapItems = checker.getNodes(busIfNode, "./spirit:signalMap/spirit:signalName");
            NodeList channelNodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:channel[normalize-space(spirit:busInterfaceRef)=\"" + busIfName + "\"]");
            int nMatchingChannels = channelNodes.getLength();
            if (nMatchingChannels > 0 && !busInterface.isMirrored()) {
                reporter.report(CheckList.CHECK_26, theDoc, MessageFormat.format(Messages.CheckChannels_6, busIfName), busIfNode);
                ++nErrors;
            }
            if (nMatchingChannels > 1) {
                reporter.report(CheckList.CHECK_29, theDoc, MessageFormat.format(Messages.CheckChannels_7, busIfName), busIfNode);
                ++nErrors;
            }
            for (String masterName : busInterface.getMasterRefs()) {
                if (masterName.length() > 0) {
                    Node masterNode = checker.getNode(theDoc.getDocumentElement(), "//spirit:busInterface[normalize-space(spirit:name)='" + masterName + "']");
                    if (masterNode == null) {
                        reporter.report(CheckList.CHECK_30, theDoc, MessageFormat.format(Messages.CheckChannels_10, busIfName, masterName), busIfNode);
                        ++nErrors;
                    } else if (!new BusInterface(xpath, masterNode).isMaster()) {
                        reporter.report(CheckList.CHECK_30, theDoc, MessageFormat.format(Messages.CheckChannels_11, busIfName), busIfNode);
                        ++nErrors;
                    }
                }
                if (busInterface.isMirrored() && masterName.length() > 0) {
                    reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckChannels_12, busIfName), busIfNode);
                    ++nErrors;
                }
                if (nMatchingChannels != 0 || masterName.length() != 0 || signalMapItems.getLength() != 0) continue;
                reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckChannels_13, busIfName), busIfNode);
                ++nErrors;
            }
            HashMap<String, Node> busDefSignals = new HashMap<String, Node>();
            try {
                signalList = busDefDoc.resolveExtends(library);
            }
            catch (Exception e) {
                signalList = new ArrayList(0);
                reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_14, e));
            }
            for (Node signalNode : signalList) {
                String signalName = busDefDoc.createXPath().evaluate("spirit:logicalName", signalNode);
                busDefSignals.put(signalName, signalNode);
            }
            for (int i = 0; i < signalMapItems.getLength(); ++i) {
                Node signalMapNode = signalMapItems.item(i);
                String componentSignalName = xpath.evaluate("./spirit:componentSignalName", signalMapNode);
                Node modelSignalNode = checker.getNode(theDoc.getDocumentElement(), "//spirit:model/spirit:signals/spirit:signal[normalize-space(spirit:name)='" + componentSignalName + "']");
                if (modelSignalNode == null) {
                    reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckChannels_19, componentSignalName), signalMapNode);
                    ++nErrors;
                    continue;
                }
                String busDefSignalName = xpath.evaluate("./spirit:busSignalName", signalMapNode);
                Node busDefSignalNode = (Node)busDefSignals.get(busDefSignalName);
                if (busDefSignalNode == null) {
                    reporter.report(CheckList.CHECK_49, theDoc, MessageFormat.format(Messages.CheckChannels_21, busDefSignalName, busDefVlnv), signalMapNode);
                    ++nErrors;
                    continue;
                }
                if ((busInterface.isMaster() || busInterface.isMirroredMaster()) && checker.getNode(busDefSignalNode, "spirit:onMaster") == null) {
                    reporter.report(CheckList.CHECK_49, theDoc, MessageFormat.format(Messages.CheckChannels_23, busDefSignalName, busDefVlnv), signalMapNode);
                    ++nErrors;
                }
                if ((busInterface.isSlave() || busInterface.isMirroredSlave()) && checker.getNode(busDefSignalNode, "spirit:onSlave") == null) {
                    reporter.report(CheckList.CHECK_49, theDoc, MessageFormat.format(Messages.CheckChannels_25, busDefSignalName, busDefVlnv), signalMapNode);
                    ++nErrors;
                }
                if ((busInterface.isSystem() || busInterface.isMirroredSystem()) && checker.getNode(busDefSignalNode, "spirit:onSystem") == null) {
                    reporter.report(CheckList.CHECK_49, theDoc, MessageFormat.format(Messages.CheckChannels_27, busDefSignalName, busDefVlnv), signalMapNode);
                    ++nErrors;
                }
                String modelDirection = xpath.evaluate("./spirit:direction", modelSignalNode);
                String busDirection = "";
                if (busInterface.isMaster() || busInterface.isMirroredSlave()) {
                    busDirection = xpath.evaluate("spirit:onMaster/spirit:direction", busDefSignalNode);
                } else if (busInterface.isSlave() || busInterface.isMirroredMaster()) {
                    busDirection = xpath.evaluate("spirit:onSlave/spirit:direction", busDefSignalNode);
                }
                if (modelDirection.length() > 0 && busDirection.length() > 0 && !modelDirection.equals(busDirection)) {
                    reporter.report(CheckList.CHECK_49, theDoc, MessageFormat.format(Messages.CheckChannels_32, busDefSignalName, busDefVlnv), signalMapNode);
                    ++nErrors;
                }
                String busWidth = "";
                if (busInterface.isMaster() || busInterface.isMirroredSlave()) {
                    busWidth = xpath.evaluate("spirit:onMaster/spirit:bitWidth", busDefSignalNode);
                } else if (busInterface.isSlave() || busInterface.isMirroredMaster()) {
                    busWidth = xpath.evaluate("spirit:onSlave/spirit:bitWidth", busDefSignalNode);
                }
                try {
                    LeftRightEvaluator signalMapBounds = new LeftRightEvaluator(xpath, signalMapNode);
                    LeftRightEvaluator modelBounds = new LeftRightEvaluator(xpath, modelSignalNode);
                    if (busWidth.length() <= 0) continue;
                    int busWidthAsInt = Integer.parseInt(busWidth);
                    if (signalMapBounds.isDefined()) {
                        if (signalMapBounds.getWidth() != busWidthAsInt) {
                            reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_36, busDefSignalName, new Integer(signalMapBounds.getWidth()), busDefVlnv, new Integer(busWidthAsInt)), signalMapNode);
                            ++nErrors;
                        }
                        if (!modelBounds.isDefined()) continue;
                        if (modelBounds.getMsb() < signalMapBounds.getMsb()) {
                            reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_37, busDefSignalName, new Integer(signalMapBounds.getMsb()), new Integer(modelBounds.getMsb())), modelSignalNode);
                            ++nErrors;
                        }
                        if (modelBounds.getLsb() <= signalMapBounds.getLsb()) continue;
                        reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_38, busDefSignalName, new Integer(signalMapBounds.getLsb()), new Integer(modelBounds.getLsb())), modelSignalNode);
                        ++nErrors;
                        continue;
                    }
                    if (modelBounds.isDefined()) {
                        if (modelBounds.getWidth() <= busWidthAsInt) continue;
                        reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_39, busDefSignalName, new Integer(modelBounds.getWidth()), busDefVlnv, new Integer(busWidthAsInt)), modelSignalNode);
                        ++nErrors;
                        continue;
                    }
                    if (busWidthAsInt <= 1) continue;
                    reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckChannels_40, busDefSignalName), modelSignalNode);
                    ++nErrors;
                    continue;
                }
                catch (NumberFormatException e) {
                    reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckChannels_41, busDefSignalName, busWidth), modelSignalNode);
                    ++nErrors;
                }
            }
        }
        NodeList channelNodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:channel");
        String message = Messages.CheckChannels_43;
        for (int i = 0; i < channelNodes.getLength(); ++i) {
            Node channel = channelNodes.item(i);
            String ifName = xpath.evaluate("spirit:busInterfaceRef", channel).trim();
            Node ifNode = checker.getNode(theDoc.getDocumentElement(), "//spirit:busInterface[normalize-space(spirit:name)='" + ifName + "']");
            if (ifNode != null) continue;
            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(message, ifName, checker.getName(channel)), channel);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkChannelConnections(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        Document componentDocument = theDoc.getBaseDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        XPath evaluator = checker.getXpathEvaluator();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:channel");
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node channelNode = nodes.item(index);
            Channel channel = new Channel(evaluator, channelNode);
            ArrayList<BusInterface> busInterfaces = new ArrayList<BusInterface>();
            List<String> busInterfaceRefs = channel.getBusInterfaceRefs();
            for (String busInterfaceName : busInterfaceRefs) {
                Node busInterfaceNode = Utilities.getBusInterface(checker, componentDocument, busInterfaceName);
                if (busInterfaceNode == null) {
                    reporter.report(CheckList.CHECK_25, theDoc, MessageFormat.format(Messages.CheckChannels_48, channel.getName(), busInterfaceName), channelNode);
                    ++nErrors;
                    continue;
                }
                busInterfaces.add(new BusInterface(evaluator, busInterfaceNode));
            }
            int size = busInterfaces.size();
            for (int index1 = 0; index1 < size; ++index1) {
                BusInterface busType1 = (BusInterface)busInterfaces.get(index1);
                for (int index2 = index1 + 1; index2 < size; ++index2) {
                    BusInterface busType2 = (BusInterface)busInterfaces.get(index2);
                    if (Utilities.areBusesCompatible(checker, busType1.getVlnv(), busType2.getVlnv())) continue;
                    reporter.report(CheckList.CHECK_25, theDoc, MessageFormat.format(Messages.CheckChannels_49, busType1.getName(), busType1.getVlnv(), busType2.getName(), busType2.getVlnv()), channelNode);
                    ++nErrors;
                }
            }
            int masters = 0;
            int slaves = 0;
            int maxMasters = channel.getMaxMasters();
            int maxSlaves = channel.getMaxSlaves();
            for (BusInterface busInterface : busInterfaces) {
                String busDefMaxSlaves;
                int value;
                if (busInterface.isMirroredMaster()) {
                    ++masters;
                } else if (busInterface.isMirroredSlave()) {
                    ++slaves;
                }
                SpiritDocument busDefinition = library.get(busInterface.getVlnv());
                if (busDefinition == null) {
                    reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckChannels_50, busInterface.getVlnv(), channel.getName()), channelNode);
                    ++nErrors;
                    continue;
                }
                Element busDefRoot = busDefinition.getBaseDocument().getDocumentElement();
                String busDefMaxMasters = evaluator.evaluate("spirit:maxMasters", busDefRoot);
                if (busDefMaxMasters.length() > 0) {
                    try {
                        value = Integer.parseInt(busDefMaxMasters);
                        maxMasters = Math.min(maxMasters, value);
                    }
                    catch (NumberFormatException nfe) {
                        reporter.report(CheckList.CHECK_ERROR, null, MessageFormat.format(Messages.CheckChannels_52, busInterface.getVlnv()));
                        ++nErrors;
                    }
                }
                if ((busDefMaxSlaves = evaluator.evaluate("spirit:maxSlaves", busDefRoot)).length() <= 0) continue;
                try {
                    value = Integer.parseInt(busDefMaxSlaves);
                    maxSlaves = Math.min(maxSlaves, value);
                }
                catch (NumberFormatException nfe) {
                    reporter.report(CheckList.CHECK_ERROR, null, MessageFormat.format(Messages.CheckChannels_54, busInterface.getVlnv()));
                    ++nErrors;
                }
            }
            if (masters > maxMasters) {
                reporter.report(CheckList.CHECK_27, theDoc, MessageFormat.format(Messages.CheckChannels_55, new Integer(masters)), channelNode);
                ++nErrors;
            }
            if (slaves <= maxSlaves) continue;
            reporter.report(CheckList.CHECK_28, theDoc, MessageFormat.format(Messages.CheckChannels_56, new Integer(slaves)), channelNode);
            ++nErrors;
        }
        return nErrors;
    }
}

