/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.MemoryRange;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.object.BusInterface;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckInterconnections {
    public static int checkInterfaceAttributes(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        SpiritLibrary library = checker.getLibrary();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:activeInterface | //spirit:monitorInterface");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            Node activeInterfaceNode = nodes.item(index);
            String componentRef = null;
            String busRef = null;
            try {
                componentRef = checker.getNode(activeInterfaceNode, "@spirit:componentRef").getNodeValue().trim();
                busRef = checker.getNode(activeInterfaceNode, "@spirit:busRef").getNodeValue().trim();
            }
            catch (Exception e) {
                reporter.report(CheckList.CHECK_12, theDoc, MessageFormat.format(Messages.CheckInterconnections_3, activeInterfaceNode.getNodeName()), activeInterfaceNode);
                ++nErrors;
                continue;
            }
            Node componentInstanceNode = Utilities.getComponentInstance(checker, checker.getSpiritDocument().getBaseDocument(), componentRef);
            if (componentInstanceNode == null) {
                reporter.report(CheckList.CHECK_12, theDoc, MessageFormat.format(Messages.CheckInterconnections_4, componentRef), activeInterfaceNode);
                ++nErrors;
                continue;
            }
            Vlnv componentVlnv = checker.getVlnvRef(componentInstanceNode);
            if (componentVlnv == null) {
                reporter.report(CheckList.CHECK_12, theDoc, MessageFormat.format(Messages.CheckInterconnections_5, componentRef), activeInterfaceNode);
                ++nErrors;
                continue;
            }
            SpiritDocument componentDoc = library.get(componentVlnv);
            if (componentDoc == null) {
                reporter.report(CheckList.CHECK_12, theDoc, MessageFormat.format(Messages.CheckInterconnections_6, componentVlnv), activeInterfaceNode);
                ++nErrors;
                continue;
            }
            Node busInterface = Utilities.getBusInterface(checker, componentDoc.getBaseDocument(), busRef);
            if (busInterface != null) continue;
            reporter.report(CheckList.CHECK_12, theDoc, MessageFormat.format(Messages.CheckInterconnections_7, componentVlnv, busRef), activeInterfaceNode);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkInterfaceCompatibility(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:interconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            Node interconnectionNode = nodes.item(index);
            Node activeInterfaceNode1 = checker.getNode(interconnectionNode, "spirit:activeInterface[1]");
            Node activeInterfaceNode2 = checker.getNode(interconnectionNode, "spirit:activeInterface[2]");
            if (activeInterfaceNode1 == null || activeInterfaceNode2 == null) {
                reporter.report(CheckList.CHECK_13, theDoc, Messages.CheckInterconnections_11, interconnectionNode);
                ++nErrors;
                continue;
            }
            Vlnv busTypeVlnv1 = Utilities.getBusTypeVlnvForActiveInterface(checker, activeInterfaceNode1);
            Vlnv busTypeVlnv2 = Utilities.getBusTypeVlnvForActiveInterface(checker, activeInterfaceNode2);
            if (busTypeVlnv1 == null || busTypeVlnv2 == null || Utilities.areBusesCompatible(checker, busTypeVlnv1, busTypeVlnv2)) continue;
            reporter.report(CheckList.CHECK_13, theDoc, Messages.CheckInterconnections_12, interconnectionNode);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkInterfaceUniqueness(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:activeInterface");
        int length = nodes.getLength();
        HashSet<String> set = new HashSet<String>(length);
        for (int index = 0; index < length; ++index) {
            Node activeInterfaceNode = nodes.item(index);
            String componentRef = null;
            String busRef = null;
            try {
                componentRef = checker.getNode(activeInterfaceNode, "@spirit:componentRef").getNodeValue().trim();
                busRef = checker.getNode(activeInterfaceNode, "@spirit:busRef").getNodeValue().trim();
            }
            catch (Exception e) {
                continue;
            }
            String value = componentRef + '/' + busRef;
            if (set.add(value)) continue;
            checker.getReporter().report(CheckList.CHECK_14, theDoc, MessageFormat.format(Messages.CheckInterconnections_16, value), activeInterfaceNode);
            ++nErrors;
        }
        set.clear();
        return nErrors;
    }

    public static int checkInterfacePolarity(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:interconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            String systemGroup2;
            String systemGroup1;
            Node interconnectionNode = nodes.item(index);
            Node activeInterfaceNode1 = checker.getNode(interconnectionNode, "spirit:activeInterface[1]");
            Node activeInterfaceNode2 = checker.getNode(interconnectionNode, "spirit:activeInterface[2]");
            if (activeInterfaceNode1 == null || activeInterfaceNode2 == null) continue;
            Element busInterface1 = Utilities.getBusInterfaceForActiveInterface(checker, activeInterfaceNode1);
            Element busInterface2 = Utilities.getBusInterfaceForActiveInterface(checker, activeInterfaceNode2);
            if (busInterface1 == null || busInterface2 == null) continue;
            XPath evaluator = checker.getXpathEvaluator();
            BusInterface busType1 = new BusInterface(evaluator, busInterface1);
            busType1.setContext(evaluator.evaluate("@spirit:componentRef", activeInterfaceNode1));
            BusInterface busType2 = new BusInterface(evaluator, busInterface2);
            busType2.setContext(evaluator.evaluate("@spirit:componentRef", activeInterfaceNode2));
            String message = MessageFormat.format(Messages.CheckInterconnections_22, busType1, busType2);
            if (busType1.isMaster() && !busType2.isMirroredMaster() && !busType2.isSlave()) {
                reporter.report(CheckList.CHECK_15, theDoc, message, interconnectionNode);
                ++nErrors;
            } else if (busType1.isMirroredMaster() && !busType2.isMaster()) {
                reporter.report(CheckList.CHECK_16, theDoc, message, interconnectionNode);
                ++nErrors;
            } else if (busType1.isSlave() && !busType2.isMirroredSlave() && !busType2.isMaster()) {
                reporter.report(CheckList.CHECK_17, theDoc, message, interconnectionNode);
                ++nErrors;
            } else if (busType1.isMirroredSlave() && !busType2.isSlave()) {
                reporter.report(CheckList.CHECK_18, theDoc, message, interconnectionNode);
                ++nErrors;
            } else if (busType1.isSystem() && !busType2.isMirroredSystem()) {
                reporter.report(CheckList.CHECK_19, theDoc, message, interconnectionNode);
                ++nErrors;
            } else if (busType1.isMirroredSystem() && !busType2.isSystem()) {
                reporter.report(CheckList.CHECK_20, theDoc, message, interconnectionNode);
                ++nErrors;
            }
            if ((busType1.isMirroredSystem() && busType2.isSystem() || busType1.isSystem() && busType2.isMirroredSystem()) && !(systemGroup1 = busType1.getSystemGroup()).equals(systemGroup2 = busType2.getSystemGroup())) {
                reporter.report(CheckList.CHECK_24, theDoc, MessageFormat.format(Messages.CheckInterconnections_23, busType1, busType2), interconnectionNode);
                ++nErrors;
            }
            if (!busType1.isMonitor() && !busType2.isMonitor()) continue;
            reporter.report(CheckList.CHECK_31, theDoc, Messages.CheckInterconnections_24, interconnectionNode);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkDirectConnections(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:interconnection");
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            String slaveBitsInLau;
            String addressSpaceRef;
            Node interconnectionNode = nodes.item(index);
            Node activeInterfaceNode1 = checker.getNode(interconnectionNode, "spirit:activeInterface[1]");
            Node activeInterfaceNode2 = checker.getNode(interconnectionNode, "spirit:activeInterface[2]");
            if (activeInterfaceNode1 == null || activeInterfaceNode2 == null) continue;
            Element busInterface1 = Utilities.getBusInterfaceForActiveInterface(checker, activeInterfaceNode1);
            Element busInterface2 = Utilities.getBusInterfaceForActiveInterface(checker, activeInterfaceNode2);
            if (busInterface1 == null || busInterface2 == null) continue;
            XPath evaluator = checker.getXpathEvaluator();
            BusInterface busType1 = new BusInterface(evaluator, busInterface1);
            busType1.setContext(evaluator.evaluate("@spirit:componentRef", activeInterfaceNode1));
            BusInterface busType2 = new BusInterface(evaluator, busInterface2);
            busType2.setContext(evaluator.evaluate("@spirit:componentRef", activeInterfaceNode2));
            BusInterface master = null;
            BusInterface slave = null;
            if (busType1.isMaster() && busType2.isSlave()) {
                master = busType1;
                slave = busType2;
            } else if (busType2.isMaster() && busType1.isSlave()) {
                master = busType2;
                slave = busType1;
            }
            if (master == null || slave == null || "".equals(addressSpaceRef = master.getAddressSpaceRef())) continue;
            String memoryMapRef = slave.getMemoryMapRef();
            if ("".equals(memoryMapRef)) {
                reporter.report(CheckList.CHECK_INFORMATION, theDoc, MessageFormat.format(Messages.CheckInterconnections_32, slave), interconnectionNode);
                ++nErrors;
                continue;
            }
            Node addressSpace = Utilities.getAddressSpace(checker, master.getNode().getOwnerDocument(), addressSpaceRef);
            if (addressSpace == null) {
                reporter.report(CheckList.CHECK_21, theDoc, MessageFormat.format(Messages.CheckInterconnections_33, addressSpaceRef, master), interconnectionNode);
                ++nErrors;
                continue;
            }
            Node memoryMap = Utilities.getMemoryMap(checker, slave.getNode().getOwnerDocument(), memoryMapRef);
            if (memoryMap == null) {
                reporter.report(CheckList.CHECK_21, theDoc, MessageFormat.format(Messages.CheckInterconnections_34, memoryMapRef, slave), interconnectionNode);
                ++nErrors;
                continue;
            }
            String masterBitsInLau = checker.getXpathEvaluator().evaluate("spirit:bitsInLau/text()", addressSpace);
            if (!masterBitsInLau.equals(slaveBitsInLau = checker.getXpathEvaluator().evaluate("spirit:bitsInLau/text()", memoryMap))) {
                reporter.report(CheckList.CHECK_21, theDoc, MessageFormat.format(Messages.CheckInterconnections_37, master, slave), interconnectionNode);
                ++nErrors;
                continue;
            }
            try {
                List<MemoryRange> memoryMapRanges;
                MemoryRange memoryMapRange;
                long memoryMapExtent;
                String range = checker.getXpathEvaluator().evaluate("spirit:range/text()", addressSpace);
                MemoryRange addressSpaceRange = new MemoryRange("0", range);
                long addressSpaceExtent = addressSpaceRange.getExtent();
                if (Long.bitCount(addressSpaceExtent) != 1) {
                    reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckInterconnections_40, master, range), interconnectionNode);
                    ++nErrors;
                }
                if ((memoryMapExtent = (memoryMapRange = CheckInterconnections.getParallelExtent(memoryMapRanges = CheckInterconnections.getMemoryMapRange(checker, memoryMap, interconnectionNode))).getExtent()) > addressSpaceExtent) {
                    reporter.report(CheckList.CHECK_22, theDoc, MessageFormat.format(Messages.CheckInterconnections_41, master, slave, Long.toHexString(addressSpaceExtent), Long.toHexString(memoryMapExtent)), interconnectionNode);
                    ++nErrors;
                }
            }
            catch (NumberFormatException nfe) {
                reporter.report(CheckList.CHECK_22, theDoc, MessageFormat.format(Messages.CheckInterconnections_42, nfe.getMessage()), interconnectionNode);
            }
            String message1 = Messages.CheckInterconnections_43;
            String message2 = "spirit:directConnection is not \"true\" for the busDefinition with VLNV: ";
            Vlnv vlnv = master.getVlnv();
            SpiritDocument busDefinitionDocument = library.get(vlnv);
            if (busDefinitionDocument == null) {
                reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message1, vlnv), interconnectionNode);
                ++nErrors;
                continue;
            }
            if (!"true".equals(evaluator.evaluate("//spirit:directConnection", busDefinitionDocument.getBaseDocument()))) {
                reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message2, vlnv), interconnectionNode);
                ++nErrors;
            }
            if ((busDefinitionDocument = library.get(vlnv = slave.getVlnv())) == null) {
                reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message1, vlnv), interconnectionNode);
                ++nErrors;
                continue;
            }
            if ("true".equals(evaluator.evaluate("//spirit:directConnection", busDefinitionDocument.getBaseDocument()))) continue;
            reporter.report(CheckList.CHECK_23, theDoc, MessageFormat.format(message2, vlnv), interconnectionNode);
            ++nErrors;
        }
        return nErrors;
    }

    private static List<MemoryRange> getMemoryMapRange(DocumentChecker checker, Node memoryMapNode, Node interconnectionNode) throws XPathExpressionException {
        XPath evaluator = checker.getXpathEvaluator();
        ICheckerReporter reporter = checker.getReporter();
        Document componentDocument = memoryMapNode.getOwnerDocument();
        ArrayList<MemoryRange> memoryRanges = new ArrayList<MemoryRange>();
        NodeList nodes = checker.getNodes(memoryMapNode, "spirit:addressBlock | spirit:bank | spirit:subspaceMap");
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            String start = evaluator.evaluate("spirit:baseAddress/text()", node);
            if ("".equals(start)) {
                start = "0";
            }
            String type = node.getLocalName();
            String range = "0";
            if ("addressBlock".equals(type)) {
                range = evaluator.evaluate("spirit:range/text()", node);
            } else {
                if ("bank".equals(type)) {
                    List<MemoryRange> bankRanges = CheckInterconnections.getMemoryMapRange(checker, node, interconnectionNode);
                    String bankAlignment = evaluator.evaluate("@spirit:bankAlignment", node);
                    MemoryRange bankRange = "parallel".equals(bankAlignment) ? CheckInterconnections.getParallelExtent(bankRanges) : CheckInterconnections.getSerialExtent(bankRanges);
                    memoryRanges.add(bankRange);
                    continue;
                }
                if ("subspaceMap".equals(type)) {
                    String masterRef = evaluator.evaluate("@spirit:masterRef", node);
                    Node masterNode = Utilities.getBusInterface(checker, componentDocument, masterRef);
                    if (masterNode == null) {
                        reporter.report(CheckList.CHECK_22, checker.getSpiritDocument(), MessageFormat.format(Messages.CheckInterconnections_61, checker.getName(memoryMapNode), masterRef), interconnectionNode);
                        continue;
                    }
                    BusInterface master = new BusInterface(evaluator, masterNode);
                    Node addressSpace = Utilities.getAddressSpace(checker, componentDocument, master.getAddressSpaceRef());
                    if (addressSpace == null) {
                        reporter.report(CheckList.CHECK_22, checker.getSpiritDocument(), MessageFormat.format(Messages.CheckInterconnections_62, master, master.getAddressSpaceRef()), interconnectionNode);
                        continue;
                    }
                    range = evaluator.evaluate("spirit:range/text()", addressSpace);
                }
            }
            if ("".equals(range)) {
                range = "0";
            }
            memoryRanges.add(new MemoryRange(start, range));
        }
        return memoryRanges;
    }

    private static MemoryRange getParallelExtent(List<MemoryRange> memoryRanges) {
        int size = memoryRanges.size();
        if (size == 0) {
            return new MemoryRange(0L, 0L);
        }
        MemoryRange memoryRange = memoryRanges.get(0);
        long min = memoryRange.getStart();
        long max = memoryRange.getExtent();
        for (int index = 1; index < size; ++index) {
            memoryRange = memoryRanges.get(index);
            min = Math.min(min, memoryRange.getStart());
            max = Math.max(max, memoryRange.getExtent());
        }
        return new MemoryRange(0L, max - min);
    }

    private static MemoryRange getSerialExtent(List<MemoryRange> memoryRanges) {
        int size = memoryRanges.size();
        if (size == 0) {
            return new MemoryRange(0L, 0L);
        }
        MemoryRange memoryRange = memoryRanges.get(0);
        long start = memoryRange.getStart();
        long range = memoryRange.getExtent();
        for (int index = 1; index < size; ++index) {
            memoryRange = memoryRanges.get(index);
            range += memoryRange.getExtent();
        }
        return new MemoryRange(start, range);
    }
}

