/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckMemoryMaps {
    public static int checkMemoryMaps(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = CheckMemoryMaps.checkMemoryMapModularity(checker);
        nErrors += CheckMemoryMaps.checkSubspaceMaps(checker);
        return nErrors += CheckMemoryMaps.checkParallelBankSubWidths(checker);
    }

    public static int checkMemoryMapModularity(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList memoryMapList = checker.getNodes(theDoc.getDocumentElement(), "//spirit:memoryMaps/spirit:memoryMap");
        for (int index = 0; index < memoryMapList.getLength(); ++index) {
            Node memoryMapNode = memoryMapList.item(index);
            String name = checker.getName(memoryMapNode);
            int bitsInLau = 8;
            Node bitsInLauNode = checker.getNode(memoryMapNode, "spirit:bitsInLau");
            if (bitsInLauNode != null) {
                try {
                    bitsInLau = Integer.parseInt(checker.getTextContent(bitsInLauNode));
                }
                catch (NumberFormatException nfe) {
                    reporter.report(CheckList.CHECK_54, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_2, nfe.getMessage()), memoryMapNode);
                    ++nErrors;
                }
            }
            NodeList addressBlockList = checker.getNodes(memoryMapNode, ".//spirit:addressBlock");
            int addressBlockCount = addressBlockList.getLength();
            for (int abIndex = 0; abIndex < addressBlockCount; ++abIndex) {
                Node addressBlockNode = addressBlockList.item(abIndex);
                int width = -1;
                Node widthNode = checker.getNode(addressBlockNode, "spirit:width");
                try {
                    width = Integer.parseInt(checker.getTextContent(widthNode));
                }
                catch (NumberFormatException nfe) {
                    reporter.report(CheckList.CHECK_54, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_5, nfe.getMessage()), widthNode);
                    ++nErrors;
                }
                if (width < 1) {
                    reporter.report(CheckList.CHECK_54, theDoc, Messages.CheckMemoryMaps_6, addressBlockNode);
                    ++nErrors;
                }
                if (width % bitsInLau == 0) continue;
                reporter.report(CheckList.CHECK_54, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_7, name, String.valueOf(width), String.valueOf(bitsInLau)), addressBlockNode);
                ++nErrors;
            }
        }
        return nErrors;
    }

    public static int checkSubspaceMaps(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList subspaceMapList = checker.getNodes(theDoc.getDocumentElement(), ".//spirit:bank[@spirit:bankAlignment=\"parallel\"]/spirit:subspaceMap");
        int subspaceMaps = subspaceMapList.getLength();
        if (subspaceMaps > 0) {
            reporter.report(CheckList.CHECK_55, theDoc, Messages.CheckMemoryMaps_9, subspaceMapList.item(0));
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkParallelBankSubWidths(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList parallelBankList = checker.getNodes(theDoc.getDocumentElement(), ".//spirit:bank[@spirit:bankAlignment=\"parallel\"]");
        for (int pbIndex = 0; pbIndex < parallelBankList.getLength(); ++pbIndex) {
            Node parallelBank = parallelBankList.item(pbIndex);
            Node serialBank = checker.getNode(parallelBank, ".//spirit:bank[@spirit:bankAlignment=\"serial\"]");
            if (serialBank == null) continue;
            NodeList widthNodes = checker.getNodes(serialBank, ".//spirit:width");
            int width = -1;
            for (int index = 0; index < widthNodes.getLength(); ++index) {
                Node widthNode = widthNodes.item(index);
                int thisWidth = 0;
                try {
                    thisWidth = Integer.parseInt(checker.getTextContent(widthNode));
                }
                catch (NumberFormatException nfe) {
                    reporter.report(CheckList.CHECK_56, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_13, nfe.getMessage()), widthNode);
                    ++nErrors;
                }
                if (width == -1) {
                    width = thisWidth;
                    continue;
                }
                if (width == thisWidth) continue;
                reporter.report(CheckList.CHECK_56, theDoc, MessageFormat.format(Messages.CheckMemoryMaps_14, String.valueOf(thisWidth), String.valueOf(width)), widthNode);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

