/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckViews {
    public static int checkViews(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        Element rootNode = theDoc.getDocumentElement();
        Node modelNode = checker.getNode(rootNode, "spirit:model");
        if (modelNode == null) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckViews_1, rootNode);
            ++nErrors;
        } else {
            NodeList viewList = checker.getNodes(modelNode, "spirit:views/spirit:view");
            NodeList signalList = checker.getNodes(modelNode, "spirit:signals/spirit:signal");
            int views = viewList.getLength();
            if (views == 0 && signalList.getLength() == 0) {
                reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckViews_4, modelNode);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

