/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;

public class Check60Visitor
extends CheckVisitor {
    private String requiredType;

    public Check60Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        String type = hierarchicalConnection.busInterface.getType();
        String refType = hierarchicalConnection.refBusInterface.getType();
        if (this.requiredType == null) {
            this.requiredType = type;
        }
        String message = Messages.Check60Visitor_0;
        if (!this.requiredType.equals(type)) {
            this.reporter.report(CheckList.CHECK_60, null, MessageFormat.format(message, type, hierarchicalConnection.busInterfaceDoc.getVlnv(), this.requiredType));
            ++this.problems;
        }
        if (!this.requiredType.equals(refType)) {
            this.reporter.report(CheckList.CHECK_60, null, MessageFormat.format(message, refType, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), this.requiredType));
            ++this.problems;
        }
        return true;
    }
}

