/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.object.ComponentSignal;
import org.eclipse.dd.ipxact.checker.core.object.SignalName;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.w3c.dom.Node;

public class Check70Visitor
extends CheckVisitor {
    public Check70Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) throws XPathExpressionException {
        XPath evaluator = hierarchicalConnection.busInterfaceDoc.createXPath();
        String message = Messages.Check70Visitor_0;
        Map<String, SignalName> signalNames = hierarchicalConnection.busInterface.getSignalNames();
        Map<String, SignalName> refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalNames != null && refSignalNames != null) {
            Map<String, ComponentSignal> componentSignals = Utilities.getComponentSignals(hierarchicalConnection.busInterfaceDoc);
            Map<String, ComponentSignal> refComponentSignals = Utilities.getComponentSignals(hierarchicalConnection.refBusInterfaceDoc);
            for (SignalName signalName : signalNames.values()) {
                String componentSignalName = signalName.getName();
                ComponentSignal componentSignal = componentSignals.get(componentSignalName);
                ComponentSignal refComponentSignal = refComponentSignals.get(componentSignalName);
                if (componentSignal == null || refComponentSignal == null) continue;
                Node singleShotDriver = (Node)evaluator.evaluate("spirit:singleShotDriver", componentSignal.getNode(), XPathConstants.NODE);
                Node refSingleShotDriverNode = (Node)evaluator.evaluate("spirit:singleShotDriver", refComponentSignal.getNode(), XPathConstants.NODE);
                if (singleShotDriver != null && refSingleShotDriverNode == null || singleShotDriver == null && refSingleShotDriverNode != null) {
                    this.reporter.report(CheckList.CHECK_70, null, MessageFormat.format(message, this.getPresence(singleShotDriver), componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), this.getPresence(refSingleShotDriverNode), refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                    ++this.problems;
                    continue;
                }
                if (singleShotDriver == null || Utilities.compareNodes(singleShotDriver, refSingleShotDriverNode)) continue;
                this.reporter.report(CheckList.CHECK_70, null, MessageFormat.format(message, "", componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), "", refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                ++this.problems;
            }
        }
        return true;
    }

    private String getPresence(Object object) {
        return object != null ? "" : Messages.Check70Visitor_Missing;
    }
}

