/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.object;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.object.SpiritNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
extends SpiritNode {
    private List<String> busInterfaceRefs;
    private int maxMasters = Integer.MAX_VALUE;
    private int maxSlaves = Integer.MAX_VALUE;

    public Channel(XPath evaluator, Node node) throws XPathExpressionException {
        super(evaluator, node);
        this.busInterfaceRefs = new ArrayList<String>();
        NodeList busInterfaceRefNodes = (NodeList)evaluator.evaluate("spirit:busInterfaceRef/text()", node, XPathConstants.NODESET);
        for (int index = 0; index < busInterfaceRefNodes.getLength(); ++index) {
            Node busInterfaceRefNode = busInterfaceRefNodes.item(index);
            this.busInterfaceRefs.add(busInterfaceRefNode.getNodeValue().trim());
        }
        String value = this.evaluate("spirit:maxMasters");
        if (value.length() > 0) {
            try {
                this.maxMasters = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((value = this.evaluate("spirit:maxSlaves")).length() > 0) {
            try {
                this.maxSlaves = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    public List<String> getBusInterfaceRefs() {
        return this.busInterfaceRefs;
    }

    public int getMaxMasters() {
        return this.maxMasters;
    }

    public int getMaxSlaves() {
        return this.maxSlaves;
    }
}

