/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.object;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.eclipse.dd.ipxact.checker.core.object.SpiritNode;
import org.eclipse.dd.ipxact.checker.core.utils.Decode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends SpiritNode {
    private final int bitOffset;
    private final int bitWidth;
    private final String access;
    private final String description;
    private final List<Long> values = new ArrayList<Long>();

    public Field(XPath evaluator, Node node) throws Exception {
        super(evaluator, node);
        String value;
        NodeList nodeList = (NodeList)evaluator.evaluate("spirit:values/spirit:value/text()", node, XPathConstants.NODESET);
        int items = nodeList.getLength();
        for (int index = 0; index < items; ++index) {
            value = nodeList.item(index).getNodeValue().trim();
            this.values.add(new Long(Decode.decode(value)));
        }
        value = this.evaluate("spirit:bitOffset");
        this.bitOffset = value.length() > 0 ? Integer.parseInt(value) : 0;
        value = this.evaluate("spirit:bitWidth");
        this.bitWidth = value.length() > 0 ? Integer.parseInt(value) : 0;
        this.access = this.evaluate("spirit:access");
        this.description = this.evaluate("spirit:description");
    }

    public String getAccess() {
        return this.access;
    }

    public long getBitOffset() {
        return this.bitOffset;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Long> getValues() {
        return this.values;
    }

    public int getBitWidth() {
        return this.bitWidth;
    }
}

