/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.HierachicalComponentNode;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.models.ListingVisitor;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.HierarchyRef;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ActiveOrMonitorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.HierarchicalConnectionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierachyModel {
    private final HierachicalComponentNode componentHierarchyRoot = new HierachicalComponentNode(null);
    private final List<List<HierarchicalConnection>> hierarchicalConnectionChains = new ArrayList<List<HierarchicalConnection>>();

    public int buildModel(DocumentChecker checker) {
        int nErrors = 0;
        SpiritComponentDocument theDoc = (SpiritComponentDocument)checker.getSpiritDocument();
        ArrayList<HierarchicalConnection> hierarchicalConnections = new ArrayList<HierarchicalConnection>();
        nErrors += this.getHierarchicalBusInterfaces(checker, theDoc, hierarchicalConnections);
        if (!hierarchicalConnections.isEmpty()) {
            HierachicalComponentNode hierachicalComponentNode = new HierachicalComponentNode((SpiritDocument)theDoc);
            this.componentHierarchyRoot.add(hierachicalComponentNode);
            for (HierarchicalConnection hierarchicalConnection : hierarchicalConnections) {
                ArrayList<HierarchicalConnection> chain = new ArrayList<HierarchicalConnection>();
                chain.add(hierarchicalConnection);
                this.hierarchicalConnectionChains.add(chain);
                nErrors += this.followHierarchicalConnection(checker, hierarchicalConnection, chain, hierachicalComponentNode);
            }
        }
        return nErrors;
    }

    private int followHierarchicalConnection(DocumentChecker checker, HierarchicalConnection hierarchicalConnection, List<HierarchicalConnection> chain, HierachicalComponentNode hierachicalComponentNode) {
        int nErrors = 0;
        HierachicalComponentNode refHierachicalComponentNode = new HierachicalComponentNode((SpiritDocument)hierarchicalConnection.refBusInterfaceDoc);
        hierachicalComponentNode.add(refHierachicalComponentNode);
        ArrayList<HierarchicalConnection> hierarchicalConnections = new ArrayList<HierarchicalConnection>();
        nErrors += this.getHierarchicalBusInterfaces(checker, hierarchicalConnection.refBusInterfaceDoc, hierarchicalConnections);
        if (!hierarchicalConnections.isEmpty()) {
            Vlnv vlnv = hierarchicalConnection.refBusInterfaceDoc.getVlnv();
            String busInterfaceName = hierarchicalConnection.refBusInterface.getName();
            for (HierarchicalConnection refHierarchicalConnection : hierarchicalConnections) {
                if (!vlnv.equals((Object)refHierarchicalConnection.busInterfaceDoc.getVlnv()) || !busInterfaceName.equals(refHierarchicalConnection.busInterface.getName())) continue;
                chain.add(refHierarchicalConnection);
                nErrors += this.followHierarchicalConnection(checker, refHierarchicalConnection, chain, refHierachicalComponentNode);
                break;
            }
        }
        return nErrors;
    }

    private int getHierarchicalBusInterfaces(DocumentChecker checker, SpiritComponentDocument componentDoc, List<HierarchicalConnection> hierarchicalConnections) {
        int nErrors = 0;
        ICheckerReporter reporter = checker.getReporter();
        SpiritLibrary library = checker.getLibrary();
        HashSet<String> busInterfaces = new HashSet<String>();
        List hierarchyRefList = componentDoc.getHierarchyRefs();
        for (HierarchyRef hierarchyRef : hierarchyRefList) {
            SpiritDesignDocument designDoc = hierarchyRef.getDesign(library);
            if (designDoc == null) continue;
            for (HierarchicalConnectionNode hierarchicalConnectionNode : designDoc.getHierarchicalConnections()) {
                String busInterfaceName = hierarchicalConnectionNode.getBusInterfaceName();
                if (!busInterfaces.add(busInterfaceName)) {
                    reporter.report(CheckList.CHECK_ERROR, (SpiritDocument)componentDoc, MessageFormat.format(Messages.HierachyModel_3, busInterfaceName, componentDoc.getVlnv(), designDoc.getVlnv()));
                    ++nErrors;
                    continue;
                }
                BusInterface busInterface = componentDoc.getBusInterface(busInterfaceName);
                if (busInterface == null) {
                    reporter.report(CheckList.CHECK_WARNING, (SpiritDocument)componentDoc, MessageFormat.format(Messages.HierachyModel_4, designDoc.getVlnv(), busInterfaceName, componentDoc.getVlnv()));
                    ++nErrors;
                    continue;
                }
                SpiritComponentDocument refComponentDoc = Utilities.getComponentDocumentForHierConnection(checker, hierarchicalConnectionNode);
                if (refComponentDoc == null) {
                    String componentInstanceName = hierarchicalConnectionNode.getUniqueDescendantText("componentRef");
                    reporter.report(CheckList.CHECK_ERROR, (SpiritDocument)componentDoc, MessageFormat.format(Messages.HierachyModel_6, designDoc.getVlnv(), componentInstanceName));
                    ++nErrors;
                    continue;
                }
                SchemaInfo.IpxactVersion v = hierarchicalConnectionNode.schemaVersion();
                String refBusInterfaceName = null;
                switch (v) {
                    case BEFORE_V14: {
                        refBusInterfaceName = hierarchicalConnectionNode.getUniqueDescendantText("interfaceRef");
                        break;
                    }
                    case V14: {
                        ActiveOrMonitorInterface activeInterface = (ActiveOrMonitorInterface)hierarchicalConnectionNode.getUniqueDescendantElement("activeInterface", ActiveOrMonitorInterface.class);
                        refBusInterfaceName = activeInterface.getSpiritAttribute("busRef");
                    }
                }
                BusInterface refBusInterface = refComponentDoc.getBusInterface(refBusInterfaceName);
                if (refBusInterface == null) {
                    reporter.report(CheckList.CHECK_ERROR, (SpiritDocument)componentDoc, MessageFormat.format(Messages.HierachyModel_8, designDoc.getVlnv(), refBusInterfaceName, refComponentDoc.getVlnv()));
                    ++nErrors;
                    continue;
                }
                HierarchicalConnection hierarchicalConnection = new HierarchicalConnection(busInterface, componentDoc, refBusInterface, refComponentDoc);
                hierarchicalConnections.add(hierarchicalConnection);
            }
        }
        return nErrors;
    }

    public HierachicalComponentNode getComponentHierarchyRoot() {
        return this.componentHierarchyRoot;
    }

    public List<List<HierarchicalConnection>> getHierarchicalConnectionChains() {
        return this.hierarchicalConnectionChains;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bus Interfaces:\n");
        for (List<HierarchicalConnection> chain : this.hierarchicalConnectionChains) {
            sb.append(chain);
            sb.append('\n');
        }
        ListingVisitor listingVisitor = new ListingVisitor("Components:");
        this.componentHierarchyRoot.accept(listingVisitor);
        sb.append(listingVisitor.getListing());
        return sb.toString();
    }
}

