/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.dnd;

import java.util.Collection;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.wizards.CreateNewBusInterfaceWizard;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.ui.internal.dnd.DefaultDragAndDropCommand;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DragBusDefinitionCommand
extends DefaultDragAndDropCommand {
    private TreeViewer fTreeViewer;

    public DragBusDefinitionCommand(SpiritDocument target, float location, int operations, int operation, Collection sources, TreeViewer treeViewer) {
        super((Object)target, location, operations, operation, sources);
        this.fTreeViewer = treeViewer;
    }

    private IStructuredModel getStructuredModel(Node node) {
        IDOMModel result = null;
        if (node instanceof IDOMNode) {
            result = ((IDOMNode)node).getModel();
        }
        return result;
    }

    private void beginModelChange(Node node) {
        IStructuredModel structuredModel = this.getStructuredModel(node);
        if (structuredModel != null) {
            String undoDesc = new String();
            if (this.getOperation() == 1 || this.getOperation() == 2) {
                undoDesc = Messages.DragBusDefinitionCommand_InsertBusInterface;
            }
            structuredModel.beginRecording((Object)this, undoDesc);
        }
    }

    private void endModelChange(Node node) {
        IStructuredModel structuredModel = this.getStructuredModel(node);
        if (structuredModel != null) {
            structuredModel.endRecording((Object)this);
        }
    }

    public boolean canExecute() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.getOperation() == 1 || this.getOperation() == 2) {
            Object input = this.fTreeViewer.getInput();
            Object sourceItem = this.sources.toArray()[0];
            Document targetDocument = (Document)input;
            this.beginModelChange(targetDocument);
            try {
                SpiritDocument sourceDocument = (SpiritDocument)sourceItem;
                Shell shell = SpiritUiPlugin.getShell();
                try {
                    CreateNewBusInterfaceWizard.addBusToComponent(shell, SpiritDocumentFactory.getFactory().create(targetDocument), sourceDocument);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.endModelChange(targetDocument);
            }
        }
    }
}

