/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.wizards;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.utils.LayoutHelper;
import org.eclipse.dd.ipxact.editor.ui.wizards.AbstractWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SetVlnvPage
extends AbstractWizardPage {
    private static final String DEFAULT_VLNV_VERSION = "1.0";
    private static final String[] LABELS = new String[]{Messages.SetVlnvPage_Vendor, Messages.SetVlnvPage_Library, Messages.SetVlnvPage_Name, Messages.SetVlnvPage_Version};
    private static final String[] DEFAULT_PREFERENCE_NAMES = new String[]{"DefaultVendorName", "DefaultLibraryName", null, null};
    private static final String USER_NAME = System.getProperty("user.name", "");
    private final String[] defaultValues = new String[]{USER_NAME, USER_NAME + "Lib", "", "1.0"};
    private Text[] vlnvText = new Text[4];

    public SetVlnvPage() {
        super("SetVlnvPage");
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        IPreferencesService preferenceService = Platform.getPreferencesService();
        for (int index = 0; index < 4; ++index) {
            String value;
            if (DEFAULT_PREFERENCE_NAMES[index] == null) continue;
            this.defaultValues[index] = value = preferenceService.getString("org.eclipse.dd.ipxact.editor.ui", DEFAULT_PREFERENCE_NAMES[index], this.defaultValues[index], null);
        }
    }

    public void createControl(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        containerGroup.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)containerGroup);
        for (int i = 0; i < 4; ++i) {
            LayoutHelper.makeLabel(containerGroup, LABELS[i] + ':');
            this.vlnvText[i] = new Text(containerGroup, 2048);
            this.vlnvText[i].setText(this.defaultValues[i]);
            this.vlnvText[i].setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
            this.addMonitor((Control)this.vlnvText[i]);
        }
        this.setPageComplete(this.isVlnvSet());
    }

    protected void updatePageComplete() {
        this.setPageComplete(this.isVlnvSet());
    }

    public boolean isVlnvSet() {
        for (int i = 0; i < 4; ++i) {
            if (!this.vlnvText[i].getText().trim().equals("")) continue;
            return false;
        }
        return true;
    }

    public Vlnv getVlnv() {
        return new Vlnv(this.vlnvText[0].getText(), this.vlnvText[1].getText(), this.vlnvText[2].getText(), this.vlnvText[3].getText());
    }

    public String getVlnvName() {
        return this.vlnvText[2].getText();
    }

    public void setVlnvName(String name) {
        if (name == null) {
            name = "";
        }
        this.vlnvText[2].setText(name);
    }

    public void setVlnvVersion(String version) {
        if (version == null) {
            version = "";
        }
        this.vlnvText[3].setText(version);
    }
}

