/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.events;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIFrame;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIValue;

@Immutable
public class MIBreakpointHitEvent
extends MIStoppedEvent {
    int bkptno;

    protected MIBreakpointHitEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, int bkptno) {
        super(ctx, token, results, frame);
        this.bkptno = bkptno;
    }

    public int getNumber() {
        return this.bkptno;
    }

    public static MIBreakpointHitEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, MIResult[] results) {
        int bkptno = -1;
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (!var.equals("bkptno")) continue;
            try {
                bkptno = Integer.parseInt(str.trim());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new MIBreakpointHitEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), bkptno);
    }
}

