/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.events;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIFrame;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIValue;

@Immutable
public class MISignalEvent
extends MIStoppedEvent {
    private final String sigName;
    private final String sigMeaning;

    protected MISignalEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String sigName, String sigMeaning) {
        super(ctx, token, results, frame);
        this.sigName = sigName;
        this.sigMeaning = sigMeaning;
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public static MISignalEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, MIResult[] results) {
        String sigName = "";
        String sigMeaning = "";
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("signal-name")) {
                sigName = str;
                continue;
            }
            if (!var.equals("signal-meaning")) continue;
            sigMeaning = str;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new MISignalEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), sigName, sigMeaning);
    }
}

