/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIListThreadGroupsInfo
extends MIInfo {
    IProcessInfo[] fProcessList;
    ThreadId[] fThreadList;

    public MIListThreadGroupsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public IProcessInfo[] getGroupList() {
        return this.fProcessList;
    }

    public ThreadId[] getThreadList() {
        return this.fThreadList;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("groups")) {
                    val = results[i].getMIValue();
                    if (!(val instanceof MIList)) continue;
                    this.parseGroups((MIList)val);
                    continue;
                }
                if (!var.equals("threads") || !((val = results[i].getMIValue()) instanceof MIList)) continue;
                this.parseThreads((MIList)val);
            }
        }
        if (this.fProcessList == null) {
            this.fProcessList = new ThreadGroupInfo[0];
        }
        if (this.fThreadList == null) {
            this.fThreadList = new ThreadId[0];
        }
    }

    private void parseGroups(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fProcessList = new ThreadGroupInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            MIResult[] results = ((MITuple)values[i]).getMIResults();
            String name = "";
            String pid = "";
            for (MIResult result : results) {
                String str;
                MIValue value;
                String var = result.getVariable();
                if (var.equals("id")) {
                    value = result.getMIValue();
                    if (!(value instanceof MIConst)) continue;
                    str = ((MIConst)value).getCString();
                    name = str.trim();
                    continue;
                }
                if (!var.equals("pid") || !((value = result.getMIValue()) instanceof MIConst)) continue;
                str = ((MIConst)value).getCString();
                pid = str.trim();
            }
            this.fProcessList[i] = new ThreadGroupInfo(name, pid);
        }
    }

    private void parseThreads(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fThreadList = new ThreadId[values.length];
        block0: for (int i = 0; i < values.length; ++i) {
            MIResult[] results;
            for (MIResult result : results = ((MITuple)values[i]).getMIResults()) {
                MIValue value;
                String var = result.getVariable();
                if (!var.equals("id") || !((value = result.getMIValue()) instanceof MIConst)) continue;
                String str = ((MIConst)value).getCString();
                this.fThreadList[i] = new ThreadId(str.trim());
                continue block0;
            }
        }
    }

    public class ThreadGroupInfo
    implements IProcessInfo {
        int pid;
        String name;

        public ThreadGroupInfo(String name, String pidStr) {
            try {
                this.pid = Integer.parseInt(pidStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.name = name;
        }

        public ThreadGroupInfo(String name, int pid) {
            this.pid = pid;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getPid() {
            return this.pid;
        }
    }

    public class ThreadId {
        String fId;

        public ThreadId(String id) {
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }
    }
}

