/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.memory;

import org.eclipse.dd.dsf.debug.internal.provisional.model.IMemoryBlockUpdatePolicyProvider;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SelectUpdatePolicyAction
implements IMenuCreator,
IViewActionDelegate,
IDebugContextListener,
IActionDelegate2 {
    private IAction fAction = null;
    private IMemoryBlock fMemoryBlock = null;
    private String fUpdatePolicy = null;

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    public void init(IViewPart view) {
    }

    public void init(IAction action) {
        this.fAction = action;
        action.setMenuCreator((IMenuCreator)this);
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fMemoryBlock = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection) {
            if (((IStructuredSelection)selection).getFirstElement() instanceof IMemoryBlock) {
                this.fMemoryBlock = (IMemoryBlock)((IStructuredSelection)selection).getFirstElement();
                action.setMenuCreator((IMenuCreator)this);
                action.setEnabled(true);
            } else if (((IStructuredSelection)selection).getFirstElement() instanceof IMemoryRendering) {
                this.fMemoryBlock = ((IMemoryRendering)((IStructuredSelection)selection).getFirstElement()).getMemoryBlock();
                action.setMenuCreator((IMenuCreator)this);
                action.setEnabled(true);
            }
            if (this.fMemoryBlock != null && this.fMemoryBlock instanceof IMemoryBlockUpdatePolicyProvider) {
                String currentPolicy = ((IMemoryBlockUpdatePolicyProvider)this.fMemoryBlock).getUpdatePolicy();
                if (this.fUpdatePolicy == null) {
                    this.fUpdatePolicy = currentPolicy;
                }
                ((IMemoryBlockUpdatePolicyProvider)this.fMemoryBlock).setUpdatePolicy(this.fUpdatePolicy);
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                SelectUpdatePolicyAction.this.fillMenu(m);
            }
        });
        return menu;
    }

    private void fillMenu(Menu menu) {
        if (this.fMemoryBlock instanceof IMemoryBlockUpdatePolicyProvider) {
            IMemoryBlockUpdatePolicyProvider blockPolicy = (IMemoryBlockUpdatePolicyProvider)this.fMemoryBlock;
            String currentPolicy = blockPolicy.getUpdatePolicy();
            String[] policies = blockPolicy.getUpdatePolicies();
            for (int i = 0; i < policies.length; ++i) {
                SelectPolicy action = new SelectPolicy(policies[i], blockPolicy.getUpdatePolicyDescription(policies[i]));
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                action.setChecked(policies[i].equals(currentPolicy));
                item.fill(menu, -1);
            }
        }
    }

    class SelectPolicy
    extends Action {
        String fID;
        String fDescription;

        public SelectPolicy(String id, String description) {
            this.fID = id;
            this.fDescription = description;
        }

        public String getText() {
            return this.fDescription;
        }

        public void run() {
            ((IMemoryBlockUpdatePolicyProvider)SelectUpdatePolicyAction.this.fMemoryBlock).setUpdatePolicy(this.fID);
            SelectUpdatePolicyAction.this.fUpdatePolicy = this.fID;
        }
    }
}

