/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.update.actions;

import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.AbstractVMProviderActionDelegate;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;

public class SelectUpdatePolicyAction
extends AbstractVMProviderActionDelegate {
    private final String fUpdatePolicyId;

    public SelectUpdatePolicyAction(String policyId) {
        this.fUpdatePolicyId = policyId;
    }

    protected String getUpdatePolicyId() {
        return this.fUpdatePolicyId;
    }

    public void init(IViewPart view) {
        super.init(view);
        this.update();
    }

    public void run(IAction action) {
        ICachingVMProvider cachingProvider;
        IVMUpdatePolicy policy;
        IVMProvider provider = this.getVMProvider();
        if (provider instanceof ICachingVMProvider && (policy = this.getPolicyFromProvider(cachingProvider = (ICachingVMProvider)provider, this.getUpdatePolicyId())) != null) {
            cachingProvider.setActiveUpdatePolicy(policy);
        }
    }

    private IVMUpdatePolicy getPolicyFromProvider(ICachingVMProvider provider, String id) {
        for (IVMUpdatePolicy policy : provider.getAvailableUpdatePolicies()) {
            if (!policy.getID().equals(id)) continue;
            return policy;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.update();
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        this.update();
    }

    protected void update() {
        IVMProvider provider = this.getVMProvider();
        if (provider instanceof ICachingVMProvider) {
            this.getAction().setEnabled(true);
            IVMUpdatePolicy activePolicy = ((ICachingVMProvider)provider).getActiveUpdatePolicy();
            this.getAction().setChecked(activePolicy != null && this.getUpdatePolicyId().equals(activePolicy.getID()));
        } else {
            this.getAction().setEnabled(false);
        }
    }
}

