/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.update.actions;

import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.AbstractVMProviderActionDelegate;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdateScope;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;

public class SelectUpdateScopeAction
extends AbstractVMProviderActionDelegate {
    private final String fUpdateScopeId;

    public SelectUpdateScopeAction(String policyId) {
        this.fUpdateScopeId = policyId;
    }

    protected String getUpdateScopeId() {
        return this.fUpdateScopeId;
    }

    public void init(IViewPart view) {
        super.init(view);
        this.update();
    }

    public void run(IAction action) {
        ICachingVMProvider cachingProvider;
        IVMUpdateScope policy;
        IVMProvider provider;
        if (action.isChecked() && (provider = this.getVMProvider()) instanceof ICachingVMProvider && (policy = this.getScopeFromProvider(cachingProvider = (ICachingVMProvider)provider, this.getUpdateScopeId())) != null) {
            cachingProvider.setActiveUpdateScope(policy);
        }
    }

    private IVMUpdateScope getScopeFromProvider(ICachingVMProvider provider, String id) {
        for (IVMUpdateScope policy : provider.getAvailableUpdateScopes()) {
            if (!policy.getID().equals(id)) continue;
            return policy;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.update();
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        this.update();
    }

    protected void update() {
        IVMProvider provider = this.getVMProvider();
        if (provider instanceof ICachingVMProvider) {
            this.getAction().setEnabled(true);
            IVMUpdateScope activeScope = ((ICachingVMProvider)provider).getActiveUpdateScope();
            this.getAction().setChecked(activeScope != null && this.getUpdateScopeId().equals(activeScope.getID()));
        } else {
            this.getAction().setEnabled(false);
        }
    }
}

