/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.IExpressionUpdate;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable.VariableCellModifier;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;

public class VariableVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider,
IElementMementoProvider {
    private final IFormattedValuePreferenceStore fFormattedPrefStore;
    private final SyncVariableDataAccess fSyncVariableDataAccess;
    protected final VariableExpressionFactory fVariableExpressionFactory = new VariableExpressionFactory();
    private final String MEMENTO_NAME = "VARIABLE_MEMENTO_NAME";

    public VariableVMNode(IFormattedValuePreferenceStore prefStore, AbstractDMVMProvider provider, DsfSession session, SyncVariableDataAccess syncVariableDataAccess) {
        super(provider, session, IExpressions.IExpressionDMContext.class);
        this.fFormattedPrefStore = prefStore;
        this.fSyncVariableDataAccess = syncVariableDataAccess;
    }

    public String toString() {
        return "VariableVMNode(" + this.getSession().getId() + ")";
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new VariableExpressionVMC(dmc);
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    VariableVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)this.getServicesTracker().getService(IExpressions.class, null), (IDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IExpressions.IExpressionDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        String[] localColumns = update.getColumnIds();
                        if (localColumns == null) {
                            localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                        }
                        for (int idx = 0; idx < localColumns.length; ++idx) {
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                                update.setLabel(dmc.getExpression(), idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                                update.setLabel("", idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                                update.setLabel("Error : " + this.getStatus().getMessage(), idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                                update.setLabel("", idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) {
                                update.setLabel(dmc.getExpression(), idx);
                            }
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                        }
                        update.done();
                        return;
                    }
                    String[] localColumns = update.getColumnIds();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (int idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getName(), idx);
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getTypeName(), idx);
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel("", idx);
                        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) {
                            IVMContext vmc = (IVMContext)update.getElement();
                            IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
                            if (expression != null) {
                                update.setLabel(expression.getExpressionText(), idx);
                            } else {
                                update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getName(), idx);
                            }
                        }
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        boolean found = false;
                        for (int idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            found = true;
                            VariableVMNode.this.updateFormattedExpressionValue(update, idx, dmc, (IExpressions.IExpressionDMData)this.getData());
                            break;
                        }
                        if (!found) {
                            update.done();
                        }
                    }
                }
            }, this.getExecutor());
        }
    }

    private void updateFormattedExpressionValue(final ILabelUpdate update, final int labelIndex, final IExpressions.IExpressionDMContext dmc, IExpressions.IExpressionDMData expressionDMData) {
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.fFormattedPrefStore.getCurrentNumericFormat(context);
        expressionService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    update.setLabel("Format information not available", labelIndex);
                    update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], labelIndex);
                    update.done();
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "NATURAL.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!preferencePageFormatId.equals(fId)) continue;
                    finalFormatId = preferencePageFormatId;
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                final IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                VariableVMNode.this.getDMVMProvider().getModelData((IVMNode)VariableVMNode.this, (IViewerUpdate)update, (IDMService)expressionService, (IDMContext)valueDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)VariableVMNode.this.getSession().getExecutor(), (IViewerUpdate)update){

                    public void handleCompleted() {
                        if (!this.isSuccess()) {
                            update.setLabel("Error : " + this.getStatus().getMessage(), labelIndex);
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], labelIndex);
                            update.done();
                            return;
                        }
                        update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), labelIndex);
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], labelIndex);
                        IFormattedValues.FormattedValueDMData oldData = (IFormattedValues.FormattedValueDMData)VariableVMNode.this.getDMVMProvider().getArchivedModelData((IVMNode)VariableVMNode.this, (IViewerUpdate)update, (IDMContext)valueDmc);
                        IExpressions.IExpressionDMData oldDMData = (IExpressions.IExpressionDMData)VariableVMNode.this.getDMVMProvider().getArchivedModelData((IVMNode)VariableVMNode.this, (IViewerUpdate)update, (IDMContext)dmc);
                        if (oldData != null && !oldData.getFormattedValue().equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue())) {
                            update.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB(), labelIndex);
                        }
                        update.done();
                    }
                }, VariableVMNode.this.getExecutor());
            }
        });
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new VariableCellModifier((AbstractCachingVMProvider)this.getDMVMProvider(), this.fFormattedPrefStore, this.fSyncVariableDataAccess);
    }

    public boolean canParseExpression(IExpression expression) {
        return true;
    }

    public void update(final IExpressionUpdate update) {
        try {
            this.getSession().getExecutor().execute(new Runnable(){

                public void run() {
                    IExpressions expressionService = (IExpressions)VariableVMNode.this.getServicesTracker().getService(IExpressions.class);
                    if (expressionService != null) {
                        IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression(VariableVMNode.this.createCompositeDMVMContext(update), update.getExpression().getExpressionText());
                        VariableExpressionVMC variableVmc = new VariableExpressionVMC((IDMContext)expressionDMC);
                        variableVmc.setExpression(update.getExpression());
                        update.setExpressionElement(variableVmc);
                        update.done();
                    } else {
                        VariableVMNode.this.handleFailedUpdate(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.handleFailedUpdate(update);
        }
    }

    protected void handleFailedUpdate(IViewerUpdate update) {
        if (update instanceof IExpressionUpdate) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Update failed", null));
            update.done();
        } else {
            super.handleFailedUpdate(update);
        }
    }

    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof VariableExpressionVMC) {
            ((VariableExpressionVMC)element).setExpression(expression);
        }
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            this.getSubexpressionsUpdateElementsInSessionThread(update);
        } else {
            this.getLocalsUpdateElementsInSessionThread(update);
        }
    }

    private void getSubexpressionsUpdateElementsInSessionThread(final IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            DsfExecutor dsfExecutor = this.getSession().getExecutor();
            ViewerDataRequestMonitor<IExpressions.IExpressionDMContext[]> rm = new ViewerDataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)dsfExecutor, (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    VariableVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                    update.done();
                }
            };
            expressionService.getSubExpressions(expressionDMC, (DataRequestMonitor)rm);
        } else {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    private void getLocalsUpdateElementsInSessionThread(final IChildrenUpdate update) {
        final IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IStack.IFrameDMContext.class);
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        final IStack stackFrameService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (frameDmc == null || expressionService == null || stackFrameService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final DsfExecutor dsfExecutor = this.getSession().getExecutor();
        ViewerDataRequestMonitor<IStack.IVariableDMContext[]> rm = new ViewerDataRequestMonitor<IStack.IVariableDMContext[]>((Executor)dsfExecutor, (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                if (localsDMCs == null) {
                    VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (localsDMCs.length == 0) {
                    update.done();
                    return;
                }
                final ArrayList localsDMData = new ArrayList();
                MultiRequestMonitor<DataRequestMonitor<IStack.IVariableDMData>> mrm = new MultiRequestMonitor<DataRequestMonitor<IStack.IVariableDMData>>((Executor)dsfExecutor, null){

                    public void handleCompleted() {
                        if (!this.isSuccess()) {
                            VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        IExpressions.IExpressionDMContext[] expressionDMCs = new IExpressions.IExpressionDMContext[localsDMData.size()];
                        int i = 0;
                        for (IStack.IVariableDMData localDMData : localsDMData) {
                            expressionDMCs[i++] = expressionService.createExpression((IDMContext)frameDmc, localDMData.getName());
                        }
                        VariableVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])expressionDMCs);
                        update.done();
                    }
                };
                for (IStack.IVariableDMContext localDMC : localsDMCs) {
                    ViewerDataRequestMonitor<IStack.IVariableDMData> rm = new ViewerDataRequestMonitor<IStack.IVariableDMData>((Executor)dsfExecutor, (IViewerUpdate)update, (MultiRequestMonitor)mrm){
                        final /* synthetic */ MultiRequestMonitor val$mrm;
                        {
                            this.val$mrm = multiRequestMonitor;
                            super(x0, x1);
                        }

                        public void handleCompleted() {
                            localsDMData.add(this.getData());
                            this.val$mrm.requestMonitorDone((RequestMonitor)this);
                        }
                    };
                    mrm.add((RequestMonitor)rm);
                    VariableVMNode.this.getDMVMProvider().getModelData((IVMNode)VariableVMNode.this, (IViewerUpdate)update, (IDMService)stackFrameService, (IDMContext)localDMC, (DataRequestMonitor)rm, VariableVMNode.this.getExecutor());
                }
            }
        };
        stackFrameService.getLocals(frameDmc, (DataRequestMonitor)rm);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IExpressions.IExpressionChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IExpressions.IExpressionChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        requestMonitor.done();
    }

    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IExpressions.IExpressionChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            return 2048;
        }
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IExpressions.IExpressionChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.addNode(element, 2048);
        }
        rm.done();
    }

    private String produceExpressionElementName(String viewName, IExpressions.IExpressionDMContext expression) {
        return "Variable." + expression.getExpression();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (IElementCompareRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("VARIABLE_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IExpressions.IExpressionDMContext) {
                String elementName = this.produceExpressionElementName(request.getPresentationContext().getId(), (IExpressions.IExpressionDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (IElementMementoRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IExpressions.IExpressionDMContext) {
                String elementName = this.produceExpressionElementName(request.getPresentationContext().getId(), (IExpressions.IExpressionDMContext)dmc);
                memento.putString("VARIABLE_MEMENTO_NAME", elementName);
            }
            request.done();
        }
    }

    protected class VariableExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected VariableExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof VariableExpressionVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            VariableExpressionVMC exprVmc = (VariableExpressionVMC)element;
            IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)exprVmc.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                return exprDmc.getExpression();
            }
            return null;
        }
    }

    public class VariableExpressionVMC
    extends AbstractDMVMNode.DMVMContext
    implements IFormattedValueVMContext {
        private IExpression fExpression;

        public VariableExpressionVMC(IDMContext dmc) {
            super((AbstractDMVMNode)VariableVMNode.this, dmc);
        }

        public IFormattedValuePreferenceStore getPreferenceStore() {
            return VariableVMNode.this.fFormattedPrefStore;
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return VariableVMNode.this.fVariableExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof VariableExpressionVMC && super.equals(other)) {
                VariableExpressionVMC otherGroup = (VariableExpressionVMC)other;
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }
    }
}

