/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMEventListener;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractVMAdapter
implements IVMAdapter {
    private boolean fDisposed;
    private final Map<IPresentationContext, IVMProvider> fViewModelProviders = Collections.synchronizedMap(new HashMap());
    private final List<IMonitoredUpdate> fPendingUpdates = new ArrayList<IMonitoredUpdate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ThreadSafe
    public IVMProvider getVMProvider(IPresentationContext context) {
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            if (this.fDisposed) {
                return null;
            }
            IVMProvider provider = this.fViewModelProviders.get(context);
            if (provider == null && (provider = this.createViewModelProvider(context)) != null) {
                this.fViewModelProviders.put(context, provider);
            }
            return provider;
        }
    }

    protected Iterable<IVMProvider> getVMProviderIterable() {
        return this.fViewModelProviders.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IVMProvider[] providers = new IVMProvider[]{};
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            providers = this.fViewModelProviders.values().toArray(new IVMProvider[this.fViewModelProviders.size()]);
            this.fViewModelProviders.clear();
            this.fDisposed = true;
        }
        for (final IVMProvider provider : providers) {
            try {
                provider.getExecutor().execute(new Runnable(){

                    public void run() {
                        provider.dispose();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.handleUpdate((IViewerUpdate[])updates);
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.handleUpdate((IViewerUpdate[])updates);
    }

    public void update(IChildrenUpdate[] updates) {
        this.handleUpdate((IViewerUpdate[])updates);
    }

    private void handleUpdate(IViewerUpdate[] updates) {
        IVMProvider provider = this.getVMProvider((updates = this.wrapUpdates(updates))[0].getPresentationContext());
        if (provider != null) {
            this.updateProvider(provider, updates);
        } else {
            for (IViewerUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "No model provider for update " + update, null));
                update.done();
            }
        }
    }

    private void updateProvider(final IVMProvider provider, final IViewerUpdate[] updates) {
        try {
            provider.getExecutor().execute(new Runnable(){

                public void run() {
                    if (updates instanceof IHasChildrenUpdate[]) {
                        provider.update((IHasChildrenUpdate[])updates);
                    } else if (updates instanceof IChildrenCountUpdate[]) {
                        provider.update((IChildrenCountUpdate[])updates);
                    } else if (updates instanceof IChildrenUpdate[]) {
                        provider.update((IChildrenUpdate[])updates);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IViewerUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "Display is disposed, cannot complete update " + update, null));
                update.done();
            }
        }
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createModelProxy(element, context);
        }
        return null;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createColumnPresentation(context, element);
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.getColumnPresentationId(context, element);
        }
        return null;
    }

    public void update(IViewerInputUpdate update) {
        IVMProvider provider = this.getVMProvider(update.getPresentationContext());
        if (provider != null) {
            provider.update(update);
        }
    }

    @ThreadSafe
    protected abstract IVMProvider createViewModelProvider(IPresentationContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleEvent(final Object event) {
        ArrayList<IVMEventListener> eventListeners = new ArrayList<IVMEventListener>();
        this.aboutToHandleEvent(event);
        for (IVMProvider vmProvider : this.getVMProviderIterable()) {
            if (!(vmProvider instanceof IVMEventListener)) continue;
            eventListeners.add((IVMEventListener)((Object)vmProvider));
        }
        if (!eventListeners.isEmpty()) {
            List<IMonitoredUpdate> i$ = this.fPendingUpdates;
            synchronized (i$) {
                this.fPendingUpdates.clear();
            }
            final Executor executor = ((IVMEventListener)eventListeners.get(0)).getExecutor();
            final CountingRequestMonitor crm = new CountingRequestMonitor(executor, null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleCompleted() {
                    if (AbstractVMAdapter.this.isDisposed()) {
                        return;
                    }
                    CountingRequestMonitor updatesMonitor = new CountingRequestMonitor(executor, null){

                        protected void handleCompleted() {
                            if (AbstractVMAdapter.this.isDisposed()) {
                                return;
                            }
                            AbstractVMAdapter.this.doneHandleEvent(event);
                        }
                    };
                    List list = AbstractVMAdapter.this.fPendingUpdates;
                    synchronized (list) {
                        int pending = AbstractVMAdapter.this.fPendingUpdates.size();
                        updatesMonitor.setDoneCount(pending);
                        for (IMonitoredUpdate update : AbstractVMAdapter.this.fPendingUpdates) {
                            update.setMonitor((RequestMonitor)updatesMonitor);
                        }
                        AbstractVMAdapter.this.fPendingUpdates.clear();
                    }
                }
            };
            crm.setDoneCount(eventListeners.size());
            for (final IVMEventListener vmEventListener : eventListeners) {
                vmEventListener.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        vmEventListener.handleEvent(event, (RequestMonitor)crm);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IViewerUpdate[] wrapUpdates(IViewerUpdate[] updates) {
        if (updates.length == 0) {
            return updates;
        }
        int i = 0;
        List<IMonitoredUpdate> list = this.fPendingUpdates;
        synchronized (list) {
            for (IViewerUpdate update : updates) {
                IMonitoredUpdate wrap = this.createMonitoredUpdate(update);
                updates[i++] = wrap;
                this.fPendingUpdates.add(wrap);
            }
        }
        return updates;
    }

    private IMonitoredUpdate createMonitoredUpdate(IViewerUpdate update) {
        if (update instanceof IChildrenCountUpdate) {
            return new MonitoredChildrenCountUpdate((IChildrenCountUpdate)update);
        }
        if (update instanceof IHasChildrenUpdate) {
            return new MonitoredHasChildrenUpdate((IHasChildrenUpdate)update);
        }
        if (update instanceof IChildrenUpdate) {
            return new MonitoredChildrenUpdate((IChildrenUpdate)update);
        }
        return null;
    }

    protected void aboutToHandleEvent(Object event) {
    }

    protected void doneHandleEvent(Object event) {
    }

    static class MonitoredChildrenCountUpdate
    extends MonitoredUpdate
    implements IChildrenCountUpdate {
        public MonitoredChildrenCountUpdate(IChildrenCountUpdate update) {
            super((IViewerUpdate)update);
        }

        public void setChildCount(int numChildren) {
            ((IChildrenCountUpdate)this.fDelegate).setChildCount(numChildren);
        }
    }

    static class MonitoredHasChildrenUpdate
    extends MonitoredUpdate
    implements IHasChildrenUpdate {
        public MonitoredHasChildrenUpdate(IHasChildrenUpdate update) {
            super((IViewerUpdate)update);
        }

        public void setHasChilren(boolean hasChildren) {
            ((IHasChildrenUpdate)this.fDelegate).setHasChilren(hasChildren);
        }
    }

    static class MonitoredChildrenUpdate
    extends MonitoredUpdate
    implements IChildrenUpdate {
        public MonitoredChildrenUpdate(IChildrenUpdate update) {
            super((IViewerUpdate)update);
        }

        public int getLength() {
            return ((IChildrenUpdate)this.fDelegate).getLength();
        }

        public int getOffset() {
            return ((IChildrenUpdate)this.fDelegate).getOffset();
        }

        public void setChild(Object child, int offset) {
            ((IChildrenUpdate)this.fDelegate).setChild(child, offset);
        }
    }

    static abstract class MonitoredUpdate
    implements IMonitoredUpdate {
        protected IViewerUpdate fDelegate;
        private boolean fIsDone;
        private RequestMonitor fMonitor;

        MonitoredUpdate(IViewerUpdate update) {
            this.fDelegate = update;
        }

        public boolean isDone() {
            return this.fIsDone;
        }

        public void setMonitor(RequestMonitor monitor) {
            this.fMonitor = monitor;
            if (this.fIsDone) {
                monitor.done();
            }
        }

        public Object getElement() {
            return this.fDelegate.getElement();
        }

        public TreePath getElementPath() {
            return this.fDelegate.getElementPath();
        }

        public IPresentationContext getPresentationContext() {
            return this.fDelegate.getPresentationContext();
        }

        public Object getViewerInput() {
            return this.fDelegate.getViewerInput();
        }

        public void cancel() {
            this.fDelegate.cancel();
            if (!this.fIsDone) {
                this.fIsDone = true;
                if (this.fMonitor != null) {
                    this.fMonitor.done();
                }
            }
        }

        public void done() {
            this.fDelegate.done();
            if (!this.fIsDone) {
                this.fIsDone = true;
                if (this.fMonitor != null) {
                    this.fMonitor.done();
                }
            }
        }

        public IStatus getStatus() {
            return this.fDelegate.getStatus();
        }

        public boolean isCanceled() {
            return this.fDelegate.isCanceled();
        }

        public void setStatus(IStatus status) {
            this.fDelegate.setStatus(status);
        }
    }

    static interface IMonitoredUpdate
    extends IViewerUpdate {
        public boolean isDone();

        public void setMonitor(RequestMonitor var1);
    }
}

