/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.dd.dsf.ui.concurrent.SimpleDisplayExecutor;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.DefaultVMContentProviderStrategy;
import org.eclipse.dd.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMEventListener;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVMProvider
implements IVMProvider,
IVMEventListener {
    public static String DEBUG_PRESENTATION_ID = null;
    public static boolean DEBUG_CONTENT_PROVIDER = false;
    public static boolean DEBUG_DELTA = false;
    private final AbstractVMAdapter fVMAdapter;
    private final IPresentationContext fPresentationContext;
    private final Executor fExecutor = SimpleDisplayExecutor.getSimpleDisplayExecutor(Display.getDefault());
    private final IElementContentProvider fContentStrategy;
    private List<IVMModelProxy> fActiveModelProxies = new LinkedList<IVMModelProxy>();
    private static final IVMNode[] EMPTY_NODES_ARRAY;
    private Map<IVMNode, IVMNode[]> fChildNodesMap = new HashMap<IVMNode, IVMNode[]>();
    private IVMNode[] fNodesListCache = null;
    private boolean fDisposed = false;
    private IRootVMNode fRootNode;
    private Map<IVMModelProxy, ModelProxyEventQueue> fProxyEventQueues = new HashMap<IVMModelProxy, ModelProxyEventQueue>();

    public AbstractVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        this.fVMAdapter = adapter;
        this.fPresentationContext = presentationContext;
        this.fContentStrategy = this.createContentStrategy();
    }

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fPresentationContext;
    }

    @Override
    public AbstractVMAdapter getVMAdapter() {
        return this.fVMAdapter;
    }

    protected IElementContentProvider createContentStrategy() {
        return new DefaultVMContentProviderStrategy(this);
    }

    protected IElementContentProvider getContentStrategy() {
        return this.fContentStrategy;
    }

    protected IVMModelProxy createModelProxyStrategy(Object rootElement) {
        return new DefaultVMModelProxyStrategy(this, rootElement);
    }

    protected List<IVMModelProxy> getActiveModelProxies() {
        return this.fActiveModelProxies;
    }

    public void handleEvent(Object event) {
        this.handleEvent(event, null);
    }

    @Override
    public void handleEvent(Object event, RequestMonitor rm) {
        CountingRequestMonitor crm = new CountingRequestMonitor(this.getExecutor(), rm);
        ArrayList<IVMModelProxy> activeModelProxies = new ArrayList<IVMModelProxy>(this.getActiveModelProxies());
        crm.setDoneCount(activeModelProxies.size());
        for (IVMModelProxy proxyStrategy : activeModelProxies) {
            if (proxyStrategy.isDeltaEvent(event)) {
                if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                    DsfUIPlugin.debug("eventReceived(proxyRoot = " + proxyStrategy.getRootElement() + ", event = " + event + ")");
                }
                if (!this.fProxyEventQueues.containsKey(proxyStrategy)) {
                    this.fProxyEventQueues.put(proxyStrategy, new ModelProxyEventQueue());
                    if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("eventQueued(proxyRoot = " + proxyStrategy.getRootElement() + ", event = " + event + ")");
                    }
                }
                ModelProxyEventQueue queue = this.fProxyEventQueues.get(proxyStrategy);
                if (queue.fCurrentEvent != null) {
                    assert (queue.fCurrentRm != null);
                    while (!queue.fEventQueue.isEmpty()) {
                        EventInfo eventToSkipInfo = queue.fEventQueue.get(queue.fEventQueue.size() - 1);
                        if (!this.canSkipHandlingEvent(event, eventToSkipInfo.fEvent)) break;
                        if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                            DsfUIPlugin.debug("eventSkipped(proxyRoot = " + proxyStrategy.getRootElement() + ", event = " + eventToSkipInfo + ")");
                        }
                        queue.fEventQueue.remove(queue.fEventQueue.size() - 1);
                        eventToSkipInfo.fClientRm.done();
                    }
                    if (queue.fEventQueue.isEmpty() && this.canSkipHandlingEvent(event, queue.fCurrentEvent.fEvent)) {
                        if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                            DsfUIPlugin.debug("eventCancelled(proxyRoot = " + proxyStrategy.getRootElement() + ", event = " + queue.fCurrentEvent + ")");
                        }
                        queue.fCurrentRm.cancel();
                    }
                    queue.fEventQueue.add(new EventInfo(event, (RequestMonitor)crm));
                    continue;
                }
                this.doHandleEvent(queue, proxyStrategy, new EventInfo(event, (RequestMonitor)crm));
                continue;
            }
            crm.done();
        }
        List<IVMModelProxy> activeProxies = this.getActiveModelProxies();
        Iterator<IVMModelProxy> itr = this.fProxyEventQueues.keySet().iterator();
        while (itr.hasNext()) {
            if (activeProxies.contains(itr.next())) continue;
            itr.remove();
        }
    }

    private void doHandleEvent(final ModelProxyEventQueue queue, final IVMModelProxy proxyStrategy, final EventInfo eventInfo) {
        assert (queue.fCurrentEvent == null && queue.fCurrentRm == null);
        queue.fCurrentEvent = eventInfo;
        queue.fCurrentRm = new RequestMonitor(this.getExecutor(), null){

            protected void handleCompleted() {
                queue.fCurrentEvent = null;
                queue.fCurrentRm = null;
                if (!queue.fEventQueue.isEmpty()) {
                    EventInfo eventInfo2 = queue.fEventQueue.remove(0);
                    AbstractVMProvider.this.doHandleEvent(queue, proxyStrategy, eventInfo2);
                }
                eventInfo.fClientRm.done();
            }
        };
        this.handleEvent(proxyStrategy, eventInfo.fEvent, queue.fCurrentRm);
    }

    protected void handleEvent(final IVMModelProxy proxyStrategy, final Object event, RequestMonitor rm) {
        if (!proxyStrategy.isDisposed()) {
            if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("eventProcessing(proxyRoot = " + proxyStrategy.getRootElement() + ", event = " + event + ")");
            }
            proxyStrategy.createDelta(event, new DataRequestMonitor<IModelDelta>(this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess()) {
                        proxyStrategy.fireModelChanged((IModelDelta)this.getData());
                        if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || AbstractVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                            DsfUIPlugin.debug("eventDeltaFired(proxyRoot = " + proxyStrategy.getRootElement() + ", event = " + event + ")");
                        }
                    }
                    super.handleCompleted();
                }

                public String toString() {
                    return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + (Object)((Object)this) + "'" + "\n" + ((IModelDelta)this.getData()).toString();
                }
            });
        } else {
            rm.done();
        }
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return false;
    }

    @Override
    public IRootVMNode getRootVMNode() {
        return this.fRootNode;
    }

    @Override
    public IVMNode[] getAllVMNodes() {
        if (this.fNodesListCache != null) {
            return this.fNodesListCache;
        }
        ArrayList<IVMNode> list = new ArrayList<IVMNode>();
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            if (node == null) continue;
            list.add(node);
        }
        this.fNodesListCache = list.toArray(new IVMNode[list.size()]);
        return this.fNodesListCache;
    }

    @Override
    public IVMNode[] getChildVMNodes(IVMNode node) {
        IVMNode[] retVal = this.fChildNodesMap.get(node);
        if (retVal != null) {
            return retVal;
        }
        return EMPTY_NODES_ARRAY;
    }

    protected void addChildNodes(IVMNode parentNode, IVMNode[] childNodes) {
        IVMNode[] existingChildNodes = this.fChildNodesMap.get(parentNode);
        if (existingChildNodes == null) {
            this.fChildNodesMap.put(parentNode, childNodes);
        } else {
            IVMNode[] newNodes = new IVMNode[existingChildNodes.length + childNodes.length];
            System.arraycopy(existingChildNodes, 0, newNodes, 0, existingChildNodes.length);
            System.arraycopy(childNodes, 0, newNodes, existingChildNodes.length, childNodes.length);
            this.fChildNodesMap.put(parentNode, newNodes);
        }
        for (IVMNode childNode : childNodes) {
            this.addNode(childNode);
        }
        this.fNodesListCache = null;
    }

    protected void addNode(IVMNode node) {
        if (!this.fChildNodesMap.containsKey(node)) {
            this.fChildNodesMap.put(node, EMPTY_NODES_ARRAY);
        }
    }

    protected void clearNodes() {
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            node.dispose();
        }
        this.fChildNodesMap.clear();
        this.fRootNode = null;
    }

    protected void setRootNode(IRootVMNode rootNode) {
        this.fRootNode = rootNode;
    }

    @Override
    public void dispose() {
        this.clearNodes();
        this.fRootNode = null;
        this.fDisposed = true;
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    public void update(IChildrenUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    @Override
    public void updateNode(final IVMNode node, IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] updateProxies = new IHasChildrenUpdate[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            final IHasChildrenUpdate update = updates[i];
            if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("updateNodeHasChildren(node = " + node + ", update = " + update + ")");
            }
            updateProxies[i] = new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>(this.getExecutor(), (IViewerUpdate)updates[i]){

                @Override
                protected void handleSuccess() {
                    update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    update.done();
                }

                @Override
                protected void handleErrorOrWarning() {
                    if (this.getStatus().getCode() == 10003) {
                        if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || AbstractVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                            DsfUIPlugin.debug("not-supported:updateNodeHasChildren(node = " + node + ", update = " + update + ")");
                        }
                        AbstractVMProvider.this.updateNode(node, new VMChildrenUpdate((IViewerUpdate)update, -1, -1, (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(AbstractVMProvider.this.getExecutor(), (IViewerUpdate)update){

                            @Override
                            protected void handleSuccess() {
                                update.setHasChilren(!((List)this.getData()).isEmpty());
                                update.done();
                            }
                        }));
                    } else {
                        update.setStatus(this.getStatus());
                        update.done();
                    }
                }
            });
        }
        node.update(updateProxies);
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenCountUpdate update) {
        if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("updateNodeChildCount(node = " + node + ", update = " + update + ")");
        }
        node.update(new IChildrenCountUpdate[]{new VMChildrenCountUpdate((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

            @Override
            protected void handleSuccess() {
                update.setChildCount(((Integer)this.getData()).intValue());
                update.done();
            }

            @Override
            protected void handleErrorOrWarning() {
                if (this.getStatus().getCode() == 10003) {
                    if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || AbstractVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("not-supported:updateNodeChildCount(node = " + node + ", update = " + update + ")");
                    }
                    AbstractVMProvider.this.updateNode(node, new VMChildrenUpdate((IViewerUpdate)update, -1, -1, (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(AbstractVMProvider.this.getExecutor(), (IViewerUpdate)update){

                        @Override
                        protected void handleSuccess() {
                            update.setChildCount(((List)this.getData()).size());
                            update.done();
                        }
                    }));
                } else {
                    super.handleErrorOrWarning();
                }
            }
        })});
    }

    @Override
    public void updateNode(IVMNode node, IChildrenUpdate update) {
        if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("updateNodeChildren(node = " + node + ", update = " + update + ")");
        }
        node.update(new IChildrenUpdate[]{update});
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public Executor getExecutor() {
        return this.fExecutor;
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMModelProxy proxy = null;
        Iterator<IVMModelProxy> itr = this.getActiveModelProxies().iterator();
        while (itr.hasNext()) {
            IVMModelProxy next = itr.next();
            if (next == null) continue;
            if (next.getRootElement().equals(element)) {
                proxy = next;
                continue;
            }
            if (!next.isDisposed()) continue;
            itr.remove();
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        } else if (proxy.isDisposed()) {
            proxy.init(context);
        }
        return proxy;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return null;
    }

    public void update(IViewerInputUpdate update) {
        update.setInputElement(update.getElement());
        update.done();
    }

    static {
        DEBUG_PRESENTATION_ID = Platform.getDebugOption((String)"org.eclipse.dd.dsf.ui/debug/vm/presentationId");
        if (!DsfUIPlugin.DEBUG || "".equals(DEBUG_PRESENTATION_ID)) {
            DEBUG_PRESENTATION_ID = null;
        }
        DEBUG_CONTENT_PROVIDER = DsfUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf.ui/debug/vm/contentProvider"));
        DEBUG_DELTA = DsfUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf.ui/debug/vm/delta"));
        EMPTY_NODES_ARRAY = new IVMNode[0];
    }

    private class ModelProxyEventQueue {
        EventInfo fCurrentEvent = null;
        RequestMonitor fCurrentRm = null;
        List<EventInfo> fEventQueue = new LinkedList<EventInfo>();

        private ModelProxyEventQueue() {
        }
    }

    private class EventInfo {
        Object fEvent;
        RequestMonitor fClientRm;

        EventInfo(Object event, RequestMonitor rm) {
            this.fEvent = event;
            this.fClientRm = rm;
        }
    }
}

