/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxyExtension;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="#getProvider()#getExecutor()")
public class DefaultVMModelProxyStrategy
implements IVMModelProxy,
IVMModelProxyExtension {
    private final AbstractVMProvider fProvider;
    private final Object fRootElement;
    private IPresentationContext fContext;
    private Viewer fViewer;
    private boolean fDisposed = false;
    private ListenerList fListeners = new ListenerList();
    private IDoubleClickListener fDoubleClickListener;

    public DefaultVMModelProxyStrategy(AbstractVMProvider provider, Object rootElement) {
        this.fProvider = provider;
        this.fRootElement = rootElement;
    }

    @Override
    public boolean isDeltaEvent(Object event) {
        IRootVMNode rootNode = this.getVMProvider().getRootVMNode();
        return rootNode != null && rootNode.isDeltaEvent(this.getRootElement(), event) && this.getDeltaFlags(rootNode, null, event) != 0;
    }

    protected AbstractVMProvider getVMProvider() {
        return this.fProvider;
    }

    private Object[] getListeners() {
        return this.fListeners.getListeners();
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public Object getRootElement() {
        return this.fRootElement;
    }

    @Override
    public Object getViewerInput() {
        return this.fRootElement;
    }

    @Override
    public TreePath getRootPath() {
        return TreePath.EMPTY;
    }

    @Override
    public void fireModelChanged(IModelDelta delta) {
        final IModelDelta root = this.getRootDelta(delta);
        Object[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final IModelChangedListener listener = (IModelChangedListener)listeners[i];
            ISafeRunnable safeRunnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log((Throwable)exception);
                }

                public void run() throws Exception {
                    listener.modelChanged(root, (IModelProxy)DefaultVMModelProxyStrategy.this);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
        }
    }

    protected IModelDelta getRootDelta(IModelDelta delta) {
        IModelDelta parent = delta.getParentDelta();
        while (parent != null) {
            delta = parent;
            parent = delta.getParentDelta();
        }
        return delta;
    }

    public void dispose() {
        this.fDisposed = true;
        if (this.fViewer instanceof StructuredViewer && this.fDoubleClickListener != null) {
            ((StructuredViewer)this.fViewer).removeDoubleClickListener(this.fDoubleClickListener);
            this.fDoubleClickListener = null;
        }
    }

    public void init(IPresentationContext context) {
        this.fDisposed = false;
        this.fContext = context;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public void installed(final Viewer viewer) {
        this.fViewer = viewer;
        this.getVMProvider().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                DefaultVMModelProxyStrategy.this.fProvider.handleEvent(new ModelProxyInstalledEvent(DefaultVMModelProxyStrategy.this, viewer, DefaultVMModelProxyStrategy.this.fRootElement));
            }
        });
        if (this.fViewer instanceof StructuredViewer && this.fDoubleClickListener == null) {
            this.fDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent e) {
                    DefaultVMModelProxyStrategy.this.handleDoubleClick(e);
                }
            };
            ((StructuredViewer)this.fViewer).addDoubleClickListener(this.fDoubleClickListener);
        }
    }

    protected void handleDoubleClick(final DoubleClickEvent e) {
        ISelection selection;
        final AbstractVMProvider vmProvider = this.getVMProvider();
        if (!vmProvider.isDisposed() && !(selection = e.getSelection()).isEmpty() && selection instanceof ITreeSelection) {
            final TreePath path = ((ITreeSelection)selection).getPaths()[0];
            final Object input = e.getViewer().getInput();
            vmProvider.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    Object rootElement = DefaultVMModelProxyStrategy.this.getRootElement();
                    boolean eventContainsRootElement = rootElement.equals(input);
                    for (int i = 0; !eventContainsRootElement && i < path.getSegmentCount(); ++i) {
                        eventContainsRootElement = rootElement.equals(path.getSegment(i));
                    }
                    if (eventContainsRootElement) {
                        vmProvider.handleEvent(e);
                    }
                }
            });
        }
    }

    @Override
    public Viewer getViewer() {
        return this.fViewer;
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    protected int getDeltaFlags(IVMNode node, ModelDelta parentDelta, Object event) {
        int flags = node.getDeltaFlags(event);
        for (IVMNode childNode : this.getVMProvider().getChildVMNodes(node)) {
            if (childNode.equals(node)) continue;
            int childNodeDeltaFlags = this.getDeltaFlags(childNode, parentDelta, event);
            if ((childNodeDeltaFlags & 0x400) != 0) {
                childNodeDeltaFlags &= 0xFFFFFBFF;
                childNodeDeltaFlags |= 0x800;
            }
            flags |= childNodeDeltaFlags;
        }
        while (parentDelta != null) {
            if ((parentDelta.getFlags() & 0x400) != 0) {
                flags = flags & 0xFFFFFBFF & 0xFFFFF7FF;
                break;
            }
            parentDelta = (ModelDelta)parentDelta.getParentDelta();
        }
        return flags;
    }

    @Override
    public void createDelta(final Object event, final DataRequestMonitor<IModelDelta> rm) {
        final IRootVMNode rootNode = this.getVMProvider().getRootVMNode();
        rootNode.createRootDelta(this.getRootElement(), event, new DataRequestMonitor<VMDelta>(this.getVMProvider().getExecutor(), rm){

            protected void handleSuccess() {
                final IModelDelta viewRootDelta = DefaultVMModelProxyStrategy.this.getRootDelta((IModelDelta)this.getData());
                Map<IVMNode, Integer> childNodesWithDeltaFlags = DefaultVMModelProxyStrategy.this.getChildNodesWithDeltaFlags(rootNode, (ModelDelta)this.getData(), event);
                if (childNodesWithDeltaFlags.size() == 0) {
                    rm.setData((Object)viewRootDelta);
                    rm.done();
                    return;
                }
                DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(rootNode, childNodesWithDeltaFlags, (VMDelta)((Object)this.getData()), event, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        rm.setData((Object)viewRootDelta);
                        rm.done();
                    }
                });
            }
        });
    }

    protected void buildChildDeltas(final IVMNode node, final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        node.getContextsForEvent(parentDelta, event, new DataRequestMonitor<IVMContext[]>(this.getVMProvider().getExecutor(), rm){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    assert (this.getData() != null);
                    DefaultVMModelProxyStrategy.this.buildChildDeltasForEventContext((IVMContext[])this.getData(), node, event, parentDelta, nodeOffset, rm);
                } else if (this.getStatus().getCode() == 10003) {
                    DefaultVMModelProxyStrategy.this.buildChildDeltasForAllContexts(node, event, parentDelta, nodeOffset, rm);
                } else {
                    super.handleCompleted();
                }
            }
        });
    }

    protected void buildChildDeltasForEventContext(final IVMContext[] vmcs, final IVMNode node, final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        final Map<IVMNode, Integer> childNodeDeltas = this.getChildNodesWithDeltaFlags(node, parentDelta, event);
        if (childNodeDeltas.size() == 0) {
            requestMonitor.done();
            return;
        }
        boolean calculateIndex = false;
        if (nodeOffset >= 0) {
            for (int childDelta : childNodeDeltas.values()) {
                if ((childDelta & 0x300000) == 0) continue;
                calculateIndex = true;
                break;
            }
        }
        if (calculateIndex) {
            this.getVMProvider().updateNode(node, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getVMProvider().getExecutor(), requestMonitor){

                protected void handleSuccess() {
                    if (((List)this.getData()).isEmpty()) {
                        requestMonitor.done();
                        return;
                    }
                    CountingRequestMonitor countingRm = new CountingRequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), requestMonitor);
                    int count = 0;
                    for (IVMContext vmc : vmcs) {
                        int i;
                        for (i = 0; i < ((List)this.getData()).size() && !vmc.equals(((List)this.getData()).get(i)); ++i) {
                        }
                        if (i == ((List)this.getData()).size()) continue;
                        int elementIndex = nodeOffset + i;
                        VMDelta delta = parentDelta.getChildDelta(vmc);
                        if (delta == null || delta.getIndex() != elementIndex) {
                            delta = parentDelta.addNode((Object)vmc, elementIndex, 0);
                        }
                        DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(node, childNodeDeltas, delta, event, (RequestMonitor)countingRm);
                        ++count;
                    }
                    countingRm.setDoneCount(count);
                }
            }));
        } else {
            CountingRequestMonitor countingRm = new CountingRequestMonitor(this.getVMProvider().getExecutor(), requestMonitor);
            int count = 0;
            for (IVMContext vmc : vmcs) {
                VMDelta delta = parentDelta.getChildDelta(vmc);
                if (delta == null) {
                    delta = parentDelta.addNode(vmc, 0);
                }
                this.callChildNodesToBuildDelta(node, childNodeDeltas, delta, event, requestMonitor);
                ++count;
            }
            countingRm.setDoneCount(count);
        }
    }

    protected void buildChildDeltasForAllContexts(final IVMNode node, final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        final Map<IVMNode, Integer> childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(node, parentDelta, event);
        if (childNodesWithDeltaFlags.size() == 0) {
            requestMonitor.done();
            return;
        }
        boolean mustGetElements = false;
        for (int childDelta : childNodesWithDeltaFlags.values()) {
            if ((childDelta & 0xFFFFF7FF) == 0) continue;
            mustGetElements = true;
        }
        if (!mustGetElements) {
            this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, parentDelta, event, requestMonitor);
        } else {
            this.getVMProvider().updateNode(node, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getVMProvider().getExecutor(), requestMonitor){

                protected void handleSuccess() {
                    if (DefaultVMModelProxyStrategy.this.fDisposed) {
                        return;
                    }
                    if (((List)this.getData()).size() == 0) {
                        requestMonitor.done();
                        return;
                    }
                    final MultiRequestMonitor elementsDeltasMultiRequestMon = new MultiRequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), requestMonitor);
                    for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                        int elementIndex = nodeOffset >= 0 ? nodeOffset + i : -1;
                        VMDelta delta = parentDelta.getChildDelta(((List)this.getData()).get(i));
                        if (delta == null) {
                            delta = parentDelta.addNode(((List)this.getData()).get(i), elementIndex, 0);
                        }
                        DefaultVMModelProxyStrategy.this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, delta, event, elementsDeltasMultiRequestMon.add(new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), null){

                            protected void handleCompleted() {
                                elementsDeltasMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                            }
                        }));
                    }
                }
            }));
        }
    }

    protected void callChildNodesToBuildDelta(final IVMNode node, final Map<IVMNode, Integer> childNodes, final VMDelta delta, final Object event, final RequestMonitor requestMonitor) {
        assert (childNodes.size() != 0);
        boolean calculateOffsets = false;
        for (int childDelta : childNodes.values()) {
            if ((childDelta & 0x300000) == 0) continue;
            calculateOffsets = true;
            break;
        }
        this.getChildNodesElementOffsets(node, (IModelDelta)delta, calculateOffsets, new DataRequestMonitor<Map<IVMNode, Integer>>(this.getVMProvider().getExecutor(), requestMonitor){

            protected void handleSuccess() {
                final CountingRequestMonitor multiRm = new CountingRequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), requestMonitor);
                int multiRmCount = 0;
                delta.setChildCount((Integer)((Map)this.getData()).get(null));
                for (final IVMNode childNode : childNodes.keySet()) {
                    if (node.equals(childNode)) continue;
                    final int nodeOffset = (Integer)((Map)this.getData()).get(childNode);
                    childNode.buildDelta(event, delta, nodeOffset, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)multiRm){

                        protected void handleSuccess() {
                            DefaultVMModelProxyStrategy.this.buildChildDeltas(childNode, event, delta, nodeOffset, new RequestMonitor(DefaultVMModelProxyStrategy.this.getVMProvider().getExecutor(), (RequestMonitor)multiRm));
                        }
                    });
                    ++multiRmCount;
                }
                multiRm.setDoneCount(multiRmCount);
            }
        });
    }

    private void getChildNodesElementOffsets(IVMNode node, IModelDelta delta, boolean calculdateOffsets, final DataRequestMonitor<Map<IVMNode, Integer>> rm) {
        final IVMNode[] childNodes = this.getVMProvider().getChildVMNodes(node);
        assert (childNodes.length != 0);
        if (calculdateOffsets) {
            final Integer[] counts = new Integer[childNodes.length];
            MultiRequestMonitor<RequestMonitor> childrenCountMultiRequestMon = new MultiRequestMonitor<RequestMonitor>(this.getVMProvider().getExecutor(), rm){

                protected void handleSuccess() {
                    HashMap<IVMNode, Integer> data = new HashMap<IVMNode, Integer>();
                    int offset = 0;
                    for (int i = 0; i < childNodes.length; ++i) {
                        data.put(childNodes[i], offset);
                        offset += counts[i].intValue();
                    }
                    data.put(null, offset);
                    rm.setData(data);
                    rm.done();
                }
            };
            for (int i = 0; i < childNodes.length; ++i) {
                final int nodeIndex = i;
                this.getVMProvider().updateNode(childNodes[i], new VMChildrenCountUpdate(delta, this.getVMProvider().getPresentationContext(), (DataRequestMonitor<Integer>)((DataRequestMonitor)childrenCountMultiRequestMon.add((RequestMonitor)new DataRequestMonitor<Integer>(this.getVMProvider().getExecutor(), rm, (MultiRequestMonitor)childrenCountMultiRequestMon){
                    final /* synthetic */ MultiRequestMonitor val$childrenCountMultiRequestMon;
                    {
                        this.val$childrenCountMultiRequestMon = multiRequestMonitor;
                        super(x0, x1);
                    }

                    protected void handleCompleted() {
                        counts[nodeIndex] = (Integer)this.getData();
                        this.val$childrenCountMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                    }
                }))));
            }
        } else {
            HashMap<IVMNode, Integer> data = new HashMap<IVMNode, Integer>();
            for (int i = 0; i < childNodes.length; ++i) {
                data.put(childNodes[i], -1);
            }
            data.put(null, -1);
            rm.setData(data);
            rm.done();
        }
    }

    protected Map<IVMNode, Integer> getChildNodesWithDeltaFlags(IVMNode node, ModelDelta parentDelta, Object e) {
        HashMap<IVMNode, Integer> nodes = new HashMap<IVMNode, Integer>();
        for (IVMNode childNode : this.getVMProvider().getChildVMNodes(node)) {
            int delta;
            if (childNode.equals(node) || (delta = this.getDeltaFlags(childNode, parentDelta, e)) == 0) continue;
            nodes.put(childNode, delta);
        }
        return nodes;
    }
}

